/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.modification;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.db.modification.TrackedMethod;
import org.qubership.atp.environments.db.modification.TrackedType;
import org.qubership.atp.environments.model.UpdateEvent;
import org.qubership.atp.environments.service.direct.SubscriptionService;
import org.qubership.atp.environments.service.direct.UpdateEventService;

public abstract class AbstractNotifier {
    protected final UpdateEventService updateEventService;
    protected final SubscriptionService subscriptionService;
    protected final TrackedMethod method;
    protected final TrackedType type;

    public AbstractNotifier(UpdateEventService updateEventService, SubscriptionService subscriptionService, TrackedMethod method, TrackedType type) {
        this.method = method;
        this.updateEventService = updateEventService;
        this.subscriptionService = subscriptionService;
        this.type = type;
    }

    public void changeStatusEntitiesUpdateEvents(List<UUID> entitySubscriptions, @Nullable UUID idEntity, @Nonnull TrackedMethod method, @Nonnull TrackedType entityType) {
        if (idEntity == null || entitySubscriptions.isEmpty()) {
            return;
        }
        for (UUID subscriptionId : entitySubscriptions) {
            UpdateEvent updateEvent = this.updateEventService.get(subscriptionId, idEntity);
            Integer currentStatus = method.dbNotificationStatus.dataBaseIndex;
            String entityForNotice = entityType.entityForNotice;
            if (updateEvent == null) {
                this.updateEventService.create(subscriptionId, idEntity, null, currentStatus, entityForNotice);
                continue;
            }
            this.updateEventService.update(subscriptionId, idEntity, updateEvent.getTagList(), currentStatus, entityForNotice);
        }
    }

    public void notifyUpdateEntity(List<UUID> cascadeOwnerEntitySubscriptions, UUID targetEntityId, TrackedType entityType) {
        this.changeStatusEntitiesUpdateEvents(cascadeOwnerEntitySubscriptions, targetEntityId, TrackedMethod.UPDATE, entityType);
    }

    public void notifyUpdateCurrentEntity(List<UUID> entitySubscriptions, @Nullable UUID idEntity) {
        this.changeStatusEntitiesUpdateEvents(entitySubscriptions, idEntity, this.method, this.type);
    }
}

