/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.modification;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.qubership.atp.environments.db.modification.DbNotificationStatus;

public enum TrackedMethod {
    CREATE("create", DbNotificationStatus.UPDATED),
    UPDATE("update", DbNotificationStatus.UPDATED),
    DELETE("delete", DbNotificationStatus.DELETED);

    private static final ImmutableMap<String, TrackedMethod> BY_NAME;
    public final String name;
    public final DbNotificationStatus dbNotificationStatus;

    private TrackedMethod(String name, DbNotificationStatus dbNotificationStatus) {
        this.name = name;
        this.dbNotificationStatus = dbNotificationStatus;
    }

    public static Optional<TrackedMethod> getByName(String name) {
        return Optional.ofNullable((TrackedMethod)((Object)BY_NAME.get((Object)name)));
    }

    public String getName() {
        return this.name;
    }

    static {
        BY_NAME = new ImmutableMap.Builder().putAll((Iterable)Arrays.stream(TrackedMethod.values()).map(type -> new AbstractMap.SimpleEntry<String, TrackedMethod>(type.name, (TrackedMethod)((Object)type))).collect(Collectors.toList())).build();
    }
}

