/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.DatabaseDirectory;
import org.qubership.atp.environments.model.impl.DatabaseDirectoryImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DatabaseDirectoryRepositoryImpl
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final DatabaseDirectoryProjection projection = new DatabaseDirectoryProjection(this);

    @Autowired
    public DatabaseDirectoryRepositoryImpl(SQLQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Nullable
    public DatabaseDirectory getByName(@Nonnull String name) {
        return (DatabaseDirectory)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)DATABASE_DIRECTORY)).where((Predicate)DatabaseDirectoryRepositoryImpl.DATABASE_DIRECTORY.name.toLowerCase().eq((Object)name.toLowerCase(Locale.ENGLISH)))).fetchOne();
    }

    @Nonnull
    public List<DatabaseDirectory> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)DATABASE_DIRECTORY)).fetch();
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static class DatabaseDirectoryProjection
    extends MappingProjection<DatabaseDirectory> {
        static final long serialVersionUID = 42L;

        private DatabaseDirectoryProjection(DatabaseDirectoryRepositoryImpl repo) {
            super(DatabaseDirectory.class, (Expression[])AbstractRepository.DATABASE_DIRECTORY.all());
        }

        protected DatabaseDirectory map(Tuple tuple) {
            String name = (String)tuple.get((Expression)AbstractRepository.DATABASE_DIRECTORY.name);
            assert (name != null);
            String urlFormat = (String)tuple.get((Expression)AbstractRepository.DATABASE_DIRECTORY.urlFormat);
            return this.create(name, urlFormat);
        }

        protected DatabaseDirectoryImpl create(String name, String urlFormat) {
            return new DatabaseDirectoryImpl(name, urlFormat);
        }
    }
}

