/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.environments.model.SystemCategory;
import org.qubership.atp.environments.model.impl.SystemCategoryImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SystemCategoryRepositoryImpl
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final SystemCategoriesProjection projection = new SystemCategoriesProjection(this);

    @Autowired
    public SystemCategoryRepositoryImpl(SQLQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Nonnull
    public SystemCategory getById(@Nonnull UUID id) {
        return (SystemCategory)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SYSTEM_CATEGORIES)).where((Predicate)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.id.eq((Object)id))).fetchOne();
    }

    public boolean existsById(@Nonnull UUID id) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SYSTEM_CATEGORIES)).where((Predicate)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.id.eq((Object)id))).fetchCount() > 0L;
    }

    @Nonnull
    public SystemCategory getByName(@Nonnull String name) {
        SystemCategory systemCategory = (SystemCategory)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SYSTEM_CATEGORIES)).where((Predicate)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.name.toLowerCase().eq((Object)name.toLowerCase(Locale.ENGLISH)))).fetchOne();
        Preconditions.checkNotNull((Object)systemCategory, (Object)"Category not found.");
        return systemCategory;
    }

    @Nonnull
    public List<SystemCategory> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SYSTEM_CATEGORIES)).fetch();
    }

    @Nonnull
    public SystemCategory create(@Nonnull String name, String description, Long created) {
        Timestamp createdTimestamp = new Timestamp(created);
        UUID id = (UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)SYSTEM_CATEGORIES).set((Path)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.name, (Object)name)).set((Path)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.description, (Object)description)).set((Path)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.created, (Object)createdTimestamp)).executeWithKey((Path)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.id);
        return this.projection.create(id, name, description, createdTimestamp, null);
    }

    @Nonnull
    public SystemCategory update(@Nonnull UUID id, @Nonnull String name, String description, Long modified) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)SYSTEM_CATEGORIES).set((Path)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.name, (Object)name)).set((Path)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.description, (Object)description)).set((Path)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.modified, (Object)modifiedTimestamp)).where((Predicate)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.id.eq((Object)id))).execute();
        Timestamp created = (Timestamp)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.created).from((Expression)SYSTEM_CATEGORIES)).where((Predicate)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.id.eq((Object)id))).fetchOne();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Information about system categories not updated");
        return this.projection.create(id, name, description, created, modifiedTimestamp);
    }

    public void delete(UUID id) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)SYSTEM_CATEGORIES).where((Predicate)SystemCategoryRepositoryImpl.SYSTEM_CATEGORIES.id.eq((Object)id))).execute();
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static class SystemCategoriesProjection
    extends MappingProjection<SystemCategory> {
        static final long serialVersionUID = 42L;

        private SystemCategoriesProjection(SystemCategoryRepositoryImpl repo) {
            super(SystemCategory.class, (Expression[])AbstractRepository.SYSTEM_CATEGORIES.all());
        }

        protected SystemCategory map(Tuple tuple) {
            UUID uuid = (UUID)tuple.get((Expression)AbstractRepository.SYSTEM_CATEGORIES.id);
            assert (uuid != null);
            String name = (String)tuple.get((Expression)AbstractRepository.SYSTEM_CATEGORIES.name);
            assert (name != null);
            String description = (String)tuple.get((Expression)AbstractRepository.SYSTEM_CATEGORIES.description);
            Timestamp created = (Timestamp)tuple.get((Expression)AbstractRepository.SYSTEM_CATEGORIES.created);
            assert (created != null);
            Timestamp modified = (Timestamp)tuple.get((Expression)AbstractRepository.SYSTEM_CATEGORIES.modified);
            return this.create(uuid, name, description, created, modified);
        }

        protected SystemCategoryImpl create(UUID uuid, String name, String description, Timestamp created, Timestamp modified) {
            return new SystemCategoryImpl(uuid, name, description, Long.valueOf(created.getTime()), modified == null ? null : Long.valueOf(modified.getTime()));
        }
    }
}

