/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.projections;

import com.google.gson.Gson;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.impl.ConnectionImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.ConnectionRepositoryImpl;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class FullConnectionProjection
extends MappingProjection<Connection> {
    static final long serialVersionUID = 42L;
    private final transient ConnectionRepositoryImpl repo;

    public FullConnectionProjection(ConnectionRepositoryImpl repo) {
        super(Connection.class, (Expression[])AbstractRepository.CONNECTIONS.all());
        this.repo = repo;
    }

    protected Connection map(Tuple tuple) {
        UUID uuid = (UUID)tuple.get((Expression)AbstractRepository.CONNECTIONS.id);
        assert (uuid != null);
        String name = (String)tuple.get((Expression)AbstractRepository.CONNECTIONS.name);
        assert (name != null);
        String description = (String)tuple.get((Expression)AbstractRepository.CONNECTIONS.description);
        String parameters = (String)tuple.get((Expression)AbstractRepository.CONNECTIONS.parameters);
        String connectionType = (String)tuple.get((Expression)AbstractRepository.CONNECTIONS.connectionType);
        UUID sourceTemplateId = (UUID)tuple.get((Expression)AbstractRepository.CONNECTIONS.sourceTemplateId);
        String services = (String)tuple.get((Expression)AbstractRepository.CONNECTIONS.services);
        UUID systemId = (UUID)tuple.get((Expression)AbstractRepository.CONNECTIONS.systemId);
        assert (systemId != null);
        Timestamp created = (Timestamp)tuple.get((Expression)AbstractRepository.CONNECTIONS.created);
        assert (created != null);
        UUID createdBy = (UUID)tuple.get((Expression)AbstractRepository.CONNECTIONS.createdBy);
        Timestamp modified = (Timestamp)tuple.get((Expression)AbstractRepository.CONNECTIONS.modified);
        UUID modifiedBy = (UUID)tuple.get((Expression)AbstractRepository.CONNECTIONS.modifiedBy);
        UUID sourceId = (UUID)tuple.get((Expression)AbstractRepository.CONNECTIONS.sourceId);
        return this.create(uuid, name, description, (ConnectionParameters)new Gson().fromJson(parameters, ConnectionParameters.class), created, createdBy, modified, modifiedBy, systemId, connectionType, sourceTemplateId, (List)new Gson().fromJson(services, List.class), sourceId);
    }

    public ConnectionImpl create(@Nonnull UUID uuid, @Nonnull String name, String description, @Nonnull ConnectionParameters parameters, Timestamp created, UUID createdBy, Timestamp modified, UUID modifiedBy, @Nonnull UUID systemId, String connectionType, UUID sourceTemplateId, List<String> services, UUID sourceId) {
        return new ConnectionImpl(uuid, name, description, parameters, Long.valueOf(created.getTime()), createdBy, modified == null ? null : Long.valueOf(modified.getTime()), modifiedBy, systemId, connectionType, sourceTemplateId, services, sourceId);
    }
}

