/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import clover.org.apache.commons.collections.map.CaseInsensitiveMap;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.json.JSONObject;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.environments.enums.ExecutorTemplateEnum;
import org.qubership.atp.environments.enums.TaEngineParamSectionEnum;
import org.qubership.atp.environments.errorhandling.internal.EnvironmentJsonParseException;
import org.qubership.atp.environments.errorhandling.taengine.EnvironmentTaEngineValidationException;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.repo.impl.ConnectionRepositoryImpl;
import org.qubership.atp.environments.service.direct.ConnectionService;
import org.qubership.atp.environments.service.rest.client.CatalogFeignClient;
import org.qubership.atp.environments.service.rest.server.dto.TaEngineAbstractParam;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="connectionService")
public class ConnectionServiceImpl
implements ConnectionService {
    private static final Logger log = LoggerFactory.getLogger(ConnectionServiceImpl.class);
    private final ConnectionRepositoryImpl connectionRepository;
    private final CatalogFeignClient catalogClient;
    private final DateTimeUtil dateTimeUtil;
    private final Provider<UserInfo> userInfoProvider;
    @Value(value="${catalogue.integration.enabled}")
    private boolean catalogueIntegration;

    @Autowired
    public ConnectionServiceImpl(ConnectionRepositoryImpl connectionRepository, DateTimeUtil dateTimeUtil, CatalogFeignClient catalogClient, Provider<UserInfo> userInfoProvider) {
        this.connectionRepository = connectionRepository;
        this.catalogClient = catalogClient;
        this.dateTimeUtil = dateTimeUtil;
        this.userInfoProvider = userInfoProvider;
    }

    @Override
    @Nullable
    public Connection get(@Nonnull UUID id) {
        return this.connectionRepository.getById(id);
    }

    @Override
    @Nullable
    public Connection getByParentAndName(@Nonnull UUID systemId, @Nonnull String name) {
        return this.connectionRepository.getByParentIdAndName(systemId, name);
    }

    @Override
    public boolean existsById(@Nonnull UUID id) {
        return this.connectionRepository.existsById(id);
    }

    @Override
    @Nonnull
    public List<Connection> getAll() {
        return this.connectionRepository.getAll();
    }

    @Override
    @Nonnull
    public List<Connection> getAll(@Nonnull List<UUID> environmentIds, @Nonnull UUID systemCategoryId) {
        return this.connectionRepository.getAll(environmentIds, systemCategoryId);
    }

    @Override
    public List<Connection> getConnectionsByProjectId(@Nonnull UUID projectId) {
        return this.connectionRepository.getConnectionsByProjectId(projectId);
    }

    @Override
    @Nonnull
    @Transactional
    public Connection create(UUID systemId, String name, String description, ConnectionParameters parameters, String connectionType, UUID sourceTemplateId, UUID projectId, List<String> services) {
        return this.create(systemId, null, name, description, parameters, connectionType, sourceTemplateId, projectId, services, null);
    }

    @Override
    @Nonnull
    @Transactional
    public Connection create(UUID systemId, UUID connectionId, String name, String description, ConnectionParameters parameters, String connectionType, UUID sourceTemplateId, UUID projectId, List<String> services, UUID sourceId) {
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        if (parameters != null) {
            parameters.replaceAll((k, v) -> v == null ? v : v.trim());
            this.validateTaEngineProviderParameters(sourceTemplateId, parameters);
        }
        name = name.trim();
        Connection connection = connectionId == null ? this.connectionRepository.create(systemId, name, description, parameters, this.dateTimeUtil.timestampAsUtc(), userId, connectionType, sourceTemplateId, services, sourceId) : this.connectionRepository.create(systemId, connectionId, name, description, parameters, this.dateTimeUtil.timestampAsUtc(), userId, connectionType, sourceTemplateId, services, sourceId);
        if (this.catalogueIntegration && projectId != null) {
            this.catalogClient.updateActions(projectId);
        }
        return connection;
    }

    @Override
    @Nonnull
    public Connection create(UUID systemId, String name, String description, ConnectionParameters parameters, String connectionType, UUID sourceTemplateId, List<String> services) {
        return this.create(systemId, name, description, parameters, connectionType, sourceTemplateId, null, services);
    }

    @Override
    @Nonnull
    public Connection replicate(@Nonnull UUID systemId, UUID connectionId, @Nonnull String name, String description, ConnectionParameters parameters, String connectionType, UUID sourceTemplateId, List<String> services, UUID sourceId) {
        return this.create(systemId, connectionId, name, description, parameters, connectionType, sourceTemplateId, null, services, sourceId);
    }

    @Override
    public Connection update(Connection connection) {
        return this.update(connection.getId(), connection.getSystemId(), connection.getName(), connection.getDescription(), connection.getParameters(), connection.getConnectionType(), connection.getSourceTemplateId(), null, connection.getServices(), connection.getSourceId());
    }

    @Override
    @Transactional
    public Connection update(UUID id, UUID systemId, String name, String description, ConnectionParameters parameters, String connectionType, UUID sourceTemplateId, UUID projectId, List<String> services) {
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        if (parameters != null) {
            parameters.replaceAll((k, v) -> v == null ? v : v.trim());
            this.validateTaEngineProviderParameters(sourceTemplateId, parameters);
        }
        Connection connection = this.connectionRepository.update(id, systemId, name.trim(), description, parameters, this.dateTimeUtil.timestampAsUtc(), userId, connectionType, sourceTemplateId, services);
        if (this.catalogueIntegration && projectId != null) {
            this.catalogClient.updateActions(projectId);
        }
        return connection;
    }

    @Override
    @Transactional
    public Connection update(UUID id, UUID systemId, String name, String description, ConnectionParameters parameters, String connectionType, UUID sourceTemplateId, UUID projectId, List<String> services, UUID sourceId) {
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        if (parameters != null) {
            parameters.replaceAll((k, v) -> v == null ? v : v.trim());
            this.validateTaEngineProviderParameters(sourceTemplateId, parameters);
        }
        Connection connection = this.connectionRepository.update(id, systemId, name.trim(), description, parameters, this.dateTimeUtil.timestampAsUtc(), userId, connectionType, sourceTemplateId, services, sourceId);
        if (this.catalogueIntegration && projectId != null) {
            this.catalogClient.updateActions(projectId);
        }
        return connection;
    }

    @Override
    public Connection update(UUID id, UUID systemId, String name, String description, ConnectionParameters parameters, String connectionType, UUID sourceTemplateId, List<String> services) {
        return this.update(id, systemId, name, description, parameters, connectionType, sourceTemplateId, null, services);
    }

    @Override
    @Cacheable(value={"CONNECTION_TEMPLATES_CACHE"}, key="T(org.springframework.cache.interceptor.SimpleKey).EMPTY")
    public List<Connection> getConnectionTemplates() {
        return this.connectionRepository.getConnectionTemplates();
    }

    @Override
    public Connection getConnectionTemplateByName(String name) {
        return this.connectionRepository.getConnectionTemplateByName(name);
    }

    @Override
    public List<Connection> getConnectionByHost(String host) {
        return this.connectionRepository.getConnectionsByHost(host);
    }

    @Override
    @Transactional
    public void delete(UUID id) {
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        UUID systemId = this.connectionRepository.getSystemId(id);
        this.connectionRepository.delete(systemId, id, this.dateTimeUtil.timestampAsUtc(), userId);
    }

    @Override
    public void updateParameters(UUID id, ConnectionParameters parameters, List<String> services) {
        if (parameters != null) {
            parameters.replaceAll((k, v) -> v == null ? v : v.trim());
        }
        UUID systemId = this.connectionRepository.getSystemId(id);
        this.connectionRepository.updateParameters(systemId, id, parameters, this.dateTimeUtil.timestampAsUtc(), ((UserInfo)this.userInfoProvider.get()).getId(), services);
    }

    @Override
    public void validateTaEngineProviderParameters(UUID sourceTemplateId, ConnectionParameters parameters) {
        if (parameters.validationIsEnabled() && sourceTemplateId != null && sourceTemplateId.equals(Constants.Environment.System.Connection.TA_ENGINES_PROVIDER)) {
            Preconditions.checkNotNull((Object)((String)parameters.get((Object)"Acquire_Create_Tool_Request_Body")), (Object)"Acquire Create Tool Request Body can not be empty");
            ArrayList<Map<String, String>> invalidFields = new ArrayList<Map<String, String>>();
            String acquireCreateToolRequestBody = (String)parameters.get((Object)"Acquire_Create_Tool_Request_Body");
            this.checkDuplicates(acquireCreateToolRequestBody, invalidFields);
            Map<String, ?> firstLevelParameters = this.parseJsonAsMap(acquireCreateToolRequestBody, CaseInsensitiveMap.class);
            this.validateParameter((String)firstLevelParameters.get("image"), "image", null, invalidFields);
            this.validateParameter((String)firstLevelParameters.get("name"), "name", null, invalidFields);
            List argsList = (List)firstLevelParameters.get("args");
            if (argsList != null && argsList.size() > 0) {
                log.info("Args not empty");
                this.validateParameter(this.getMatchingParameter(argsList, "version"), "version", "args", invalidFields);
                this.checkUrlRules("Nexus", 2, 4, argsList, "args", invalidFields);
                this.checkUrlRules("SVN", 2, 4, argsList, "args", invalidFields);
                this.checkUrlRules("Git", 3, 5, argsList, "args", invalidFields);
                this.checkUrlRules("CP", 1, 1, argsList, "args", invalidFields);
            }
            if (invalidFields.size() > 0) {
                log.error("Failed to validate connection because of incorrect fields: {}", invalidFields);
                throw new EnvironmentTaEngineValidationException(invalidFields);
            }
        }
    }

    @Override
    public List<Connection> getByIds(List<UUID> ids) {
        List<Connection> connections = this.connectionRepository.getByIds(ids);
        return connections != null ? connections : Collections.emptyList();
    }

    @Override
    public UUID getProjectId(UUID connectionId) {
        return this.connectionRepository.getProjectId(connectionId);
    }

    private Map<String, ?> parseJsonAsMap(String jsonBody, Class<? extends Map> mapClass) {
        try {
            return (Map)new ObjectMapper().readValue(jsonBody, mapClass);
        }
        catch (IOException e) {
            log.error("Failed to parse JSON data", (Throwable)e);
            throw new EnvironmentJsonParseException("Failed to parse JSON data");
        }
    }

    private void checkDuplicates(String acquireCreateToolRequestBody, List<Map<String, String>> invalidFields) {
        List<String> excludeList = Arrays.asList("svn", "nexus", "git", "cp");
        Map<String, ?> parameterMap = this.parseJsonAsMap(acquireCreateToolRequestBody, HashMap.class);
        JSONObject jsonObject = JSONObject.fromObject((Object)acquireCreateToolRequestBody);
        this.recursiveCheck(parameterMap, null, excludeList, invalidFields);
        for (Map.Entry<String, ?> entry : parameterMap.entrySet()) {
            List listFromJson;
            List listFromMap;
            Object valueJson;
            String key = entry.getKey();
            Object valueMap = entry.getValue();
            if (valueMap.equals(valueJson = jsonObject.get(key)) || valueMap instanceof List && valueJson instanceof List && (listFromMap = (List)valueMap).equals(listFromJson = (List)valueJson)) continue;
            this.addInvalidField(invalidFields, null, key);
        }
    }

    private void validateParameter(String parameter, String parameterName, String parameterSection, List<Map<String, String>> invalidFields) {
        if (parameter == null || parameter.isEmpty()) {
            this.addInvalidField(invalidFields, parameterSection, parameterName);
        }
    }

    private void checkUrlRules(String ruleName, int minPlus, int maxPlus, List<String> argsList, String parameterSection, List<Map<String, String>> invalidFields) {
        String regexStringContainsRule = "^[-]{0,2}((?i)" + ruleName + "=).?$";
        String regexDeleteRuleName = "^[-]{0,2}((?i)" + ruleName + "=)";
        String regexUrlRule = "^(http[s]?://)[\\w\\-._~:/?#[\\\\]@!$&'()*,;=.\\\\]+([+][\\w\\-._~:/?#[\\\\]@!$&'()*,;=.\\\\]+){" + minPlus + "," + maxPlus + "}$";
        argsList.stream().filter(x -> x.matches(regexStringContainsRule)).map(x -> {
            this.validateParameter(this.getMatchingParameter(argsList, ruleName), ruleName, parameterSection, invalidFields);
            return x.replaceFirst(regexDeleteRuleName, "");
        }).allMatch(x -> {
            if (x.matches(regexUrlRule)) {
                return true;
            }
            this.addInvalidField(invalidFields, parameterSection, ruleName);
            return false;
        });
    }

    @Nonnull
    private String getMatchingParameter(List<String> parametersList, String parameter) {
        String regexFind = "^[-]{0,2}((?i)" + parameter + "=).+$";
        String regexReplace = "^[-]{0,2}((?i)" + parameter + "=)";
        return parametersList.stream().filter(x -> x.matches(regexFind)).collect(Collectors.joining()).replaceFirst(regexReplace, "");
    }

    private void addInvalidField(List<Map<String, String>> invalidFields, String section, String field) {
        field = this.findBusinessName(field, section);
        invalidFields.add(Stream.of({"name", field}, {"section", section}).collect(HashMap::new, (m, v) -> m.put(v[0], v[1]), HashMap::putAll));
    }

    private String findBusinessName(String field, String section) {
        for (ExecutorTemplateEnum templateEnum : ExecutorTemplateEnum.values()) {
            ArrayList<TaEngineAbstractParam> attributesFromTemplate = new ArrayList<TaEngineAbstractParam>();
            attributesFromTemplate.addAll(templateEnum.getTemplate().getAdditionalParams());
            attributesFromTemplate.addAll(templateEnum.getTemplate().getDefaultParams());
            attributesFromTemplate.addAll(templateEnum.getTemplate().getTaEngineParams());
            attributesFromTemplate.addAll(templateEnum.getTemplate().getTaEngineProviderParams());
            for (TaEngineAbstractParam defaultParam : attributesFromTemplate) {
                if (!defaultParam.getName().toUpperCase(Locale.ROOT).equals(field.toUpperCase(Locale.ROOT))) continue;
                TaEngineParamSectionEnum templateSection = defaultParam.getSection();
                if (section == null && templateSection == null) {
                    return defaultParam.getBusinessName();
                }
                if (section == null || templateSection == null || !section.toUpperCase(Locale.ROOT).equals(templateSection.getSection().toUpperCase(Locale.ROOT))) continue;
                return defaultParam.getBusinessName();
            }
        }
        return field;
    }

    private <T> void recursiveCheck(T parameter, String parameterSection, List<String> excludeList, List<Map<String, String>> invalidFields) {
        ArrayList<String> stringList = new ArrayList<String>();
        String regexCanBeParsedAsArray = "^[-]{0,2}(([^=](?=.))+=).+$";
        String regexCanExtractParameterName = "^[-]{0,2}([^=]+=)((?=[^\\s])[^,])+$";
        String regexExtraSymbols = "(?=[^.:])\\W";
        String regexParameterName = "^[-]{0,2}([^=]+=)";
        String regexParsingSeparator = "(\\s+-*)|(\\s?,\\s?)";
        String regexSectionName = "^[-]{0,2}(([^=](?=.))+=)";
        if (parameter instanceof List) {
            ((List)parameter).forEach(listElement -> {
                if (listElement instanceof String) {
                    Matcher matcher;
                    String stringParameter = (String)listElement;
                    if (stringParameter.matches(regexCanExtractParameterName) && (matcher = Pattern.compile(regexParameterName).matcher(stringParameter)).find()) {
                        String parameterName = matcher.group(1).toLowerCase(Locale.ROOT).replaceAll(regexExtraSymbols, "");
                        this.validateParameterInSection(parameterSection, excludeList, invalidFields, stringList, parameterName);
                    }
                } else if (listElement instanceof Map) {
                    Map parameterMap = (Map)listElement;
                    this.decomposeMapForValidation(parameterSection, excludeList, invalidFields, stringList, parameterMap);
                }
                this.recursiveCheck(listElement, parameterSection, excludeList, invalidFields);
            });
        } else if (parameter instanceof Map) {
            Map parameterMap = (Map)parameter;
            this.decomposeMapForValidation(parameterSection, excludeList, invalidFields, stringList, parameterMap);
        } else if (parameter instanceof String) {
            String stringParameter = (String)parameter;
            if (stringParameter.matches(regexCanBeParsedAsArray)) {
                Matcher matcher = Pattern.compile(regexSectionName).matcher(stringParameter);
                String sectionName = null;
                if (matcher.find()) {
                    sectionName = matcher.group(1).replaceAll(regexExtraSymbols, "");
                }
                String[] parsedStrings = stringParameter.replaceFirst(regexSectionName, "").split(regexParsingSeparator);
                this.recursiveCheck(Arrays.asList(parsedStrings), sectionName, excludeList, invalidFields);
            }
        } else {
            log.debug("object of '{}' type not processed: {}", (Object)parameter.getClass().getName(), parameter);
        }
    }

    private void validateParameterInSection(String parameterSection, List<String> excludeList, List<Map<String, String>> invalidFields, List<String> stringList, String parameterName) {
        if (stringList.contains(parameterName) && !excludeList.contains(parameterName)) {
            this.addInvalidField(invalidFields, parameterSection, parameterName);
        } else {
            stringList.add(parameterName);
        }
    }

    private void decomposeMapForValidation(String parameterSection, List<String> excludeList, List<Map<String, String>> invalidFields, List<String> stringList, Map<String, ?> parameterMap) {
        parameterMap.forEach((key, value) -> {
            if (key.equals("name") && parameterMap.containsKey("value")) {
                String parameterName = String.valueOf(value).toLowerCase(Locale.ROOT);
                this.validateParameterInSection(parameterSection, excludeList, invalidFields, stringList, parameterName);
            } else if (key.equals("value")) {
                this.recursiveCheck(value, parameterSection, excludeList, invalidFields);
            } else {
                String parameterName = key.toLowerCase(Locale.ROOT);
                this.validateParameterInSection(parameterSection, excludeList, invalidFields, stringList, parameterName);
                this.recursiveCheck(value, parameterName, excludeList, invalidFields);
            }
        });
    }
}

