/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import com.google.common.base.Preconditions;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.environments.enums.MdcField;
import org.qubership.atp.environments.errorhandling.request.EnvironmentsWithFilterRequestException;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.repo.impl.ConnectionRepositoryImpl;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SystemCategoryRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.qubership.atp.environments.service.direct.EnvironmentService;
import org.qubership.atp.environments.service.direct.ProjectAccessService;
import org.qubership.atp.environments.service.direct.SystemService;
import org.qubership.atp.environments.service.rest.server.dto.BaseSearchRequestDto;
import org.qubership.atp.environments.service.rest.server.dto.ConnectionTemporaryDto;
import org.qubership.atp.environments.service.rest.server.dto.CreateSystemDto;
import org.qubership.atp.environments.service.rest.server.dto.SystemTemporaryDto;
import org.qubership.atp.environments.service.rest.server.request.EnvironmentsWithFilterRequest;
import org.qubership.atp.environments.service.rest.server.request.ValidateTaToolsRequest;
import org.qubership.atp.environments.service.rest.server.response.GroupedByTagEnvironmentResponse;
import org.qubership.atp.environments.service.rest.server.response.ValidateTaToolResponse;
import org.qubership.atp.environments.service.rest.server.response.ValidateTaToolsResponse;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.qubership.atp.environments.validating.factories.ValidationStrategyFactory;
import org.qubership.atp.environments.validating.strategies.ValidationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCache;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="environmentService")
public class EnvironmentServiceImpl
implements EnvironmentService {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentServiceImpl.class);
    private static final String NO_TAG = "No Tags";
    private final EnvironmentRepositoryImpl environmentRepository;
    private final SystemRepositoryImpl systemRepository;
    private final ConnectionRepositoryImpl connectionRepository;
    private final SystemService systemService;
    private final SystemCategoryRepositoryImpl systemCategoryRepository;
    private final DateTimeUtil dateTimeUtil;
    private final Provider<UserInfo> userInfoProvider;
    private final UUID categoryId = Constants.Environment.Category.TEMPORARY_ENVIRONMENT;
    private final String trStyle = "border-collapse: collapse;";
    private final String tdStyle = "border: 1px solid rgb(0,0,0)";
    private final ProjectAccessService projectAccessService;
    private final Cache environmentsBySystemIdCachedMap;
    private final ValidationStrategyFactory validationStrategyFactory;

    @Autowired
    public EnvironmentServiceImpl(EnvironmentRepositoryImpl environmentRepository, SystemRepositoryImpl systemRepository, ConnectionRepositoryImpl connectionRepository, SystemService systemService, SystemCategoryRepositoryImpl systemCategoryRepository, DateTimeUtil dateTimeUtil, Provider<UserInfo> userInfoProvider, ProjectAccessService projectAccessService, CacheManager cacheManager, ValidationStrategyFactory validationStrategyFactory) {
        this.environmentRepository = environmentRepository;
        this.systemRepository = systemRepository;
        this.connectionRepository = connectionRepository;
        this.systemService = systemService;
        this.systemCategoryRepository = systemCategoryRepository;
        this.dateTimeUtil = dateTimeUtil;
        this.userInfoProvider = userInfoProvider;
        this.projectAccessService = projectAccessService;
        this.validationStrategyFactory = validationStrategyFactory;
        this.environmentsBySystemIdCachedMap = cacheManager != null && cacheManager.getCache("ATP_ENVIRONMENTS-ENVIRONMENTS_BY_SYSTEM_ID") != null ? cacheManager.getCache("ATP_ENVIRONMENTS-ENVIRONMENTS_BY_SYSTEM_ID") : new NoOpCache("ATP_ENVIRONMENTS-ENVIRONMENTS_BY_SYSTEM_ID");
    }

    @Override
    @Nullable
    public Environment get(@Nonnull UUID id) {
        Environment env = this.environmentRepository.getById(id);
        Preconditions.checkNotNull((Object)env, (String)"Wrong environment id: %s", (Object)id);
        return env;
    }

    @Override
    @Nullable
    public String getEnvironmentNameById(@Nonnull UUID id) {
        return this.environmentRepository.getNameById(id);
    }

    @Override
    public Optional<Environment> getOrElse(@Nonnull UUID id) {
        return Optional.ofNullable(this.environmentRepository.getById(id));
    }

    @Override
    public boolean existsById(@Nonnull UUID id) {
        return this.environmentRepository.existsById(id);
    }

    @Override
    @Nonnull
    public List<Environment> getAll() {
        return this.environmentRepository.getAll();
    }

    @Override
    @Nonnull
    public List<Environment> getAll(UUID categoryId) {
        return this.environmentRepository.getAll(categoryId);
    }

    @Override
    @Nonnull
    @Transactional
    public Environment create(UUID projectId, String name, String graylogName, String description, String ssmSolutionAlias, String ssmInstanceAlias, String consulEgressConfigPath, UUID categoryId, List<String> tags) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        return this.environmentRepository.create(name.trim(), graylogName, description, ssmSolutionAlias, ssmInstanceAlias, consulEgressConfigPath, this.dateTimeUtil.timestampAsUtc(), userId, projectId, categoryId, tags);
    }

    @Override
    @Transactional
    public System create(UUID environmentId, CreateSystemDto systemDto) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        return this.systemService.create(environmentId, systemDto);
    }

    @Override
    @Nonnull
    @Transactional
    public Environment replicate(@Nonnull UUID projectId, @Nonnull UUID environmentId, String name, String graylogName, String description, String ssmSolutionAlias, String ssmInstanceAlias, String consulEgressConfigPath, UUID categoryId, UUID sourceId, List<String> tags) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        return this.environmentRepository.create(environmentId, name.trim(), graylogName, description, ssmSolutionAlias, ssmInstanceAlias, consulEgressConfigPath, this.dateTimeUtil.timestampAsUtc(), userId, projectId, categoryId, sourceId, tags);
    }

    private HashMap<UUID, UUID> getMapReferencesToCopy(Environment environmentToCopy, UUID newEnvironmentId) {
        HashMap<UUID, UUID> referencesMap = new HashMap<UUID, UUID>();
        environmentToCopy.getSystems().stream().filter(system -> system.getLinkToSystemId() != null).forEach(system -> {
            System parentSystem;
            if (!referencesMap.containsKey(system.getLinkToSystemId()) && Objects.nonNull(parentSystem = this.getParentSystem(environmentToCopy, system.getLinkToSystemId()))) {
                referencesMap.put(parentSystem.getId(), this.createSystem(newEnvironmentId, parentSystem).getId());
            }
        });
        environmentToCopy.getSystems().removeIf(system -> referencesMap.containsKey(system.getId()));
        return referencesMap;
    }

    private System getParentSystem(Environment environment, UUID linkToSystemId) {
        if (!Objects.isNull(environment.getSystems())) {
            for (System system : environment.getSystems()) {
                if (!system.getId().equals(linkToSystemId)) continue;
                return system;
            }
        }
        return null;
    }

    @Override
    @Transactional
    public Environment copy(UUID id, UUID projectId, String name, String graylogName, String description, String ssmSolutionAlias, String ssmInstanceAlias, String consulEgressConfigPath, UUID categoryId, List<String> tags) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        Environment toCopy = this.environmentRepository.getById(id);
        Preconditions.checkNotNull((Object)toCopy, (String)"Environment %s can't be empty", (Object)id);
        Environment newEnv = this.environmentRepository.create(name, graylogName, description, ssmSolutionAlias, ssmInstanceAlias, consulEgressConfigPath, this.dateTimeUtil.timestampAsUtc(), userId, projectId, categoryId, tags);
        HashMap<UUID, UUID> referencesMap = this.getMapReferencesToCopy(toCopy, newEnv.getId());
        toCopy.getSystems().forEach(system -> {
            if (system.getEnvironments().size() > 1 && toCopy.getProjectId().equals(projectId)) {
                this.systemRepository.share(system.getId(), newEnv, this.dateTimeUtil.timestampAsUtc(), userId);
            } else {
                if (Objects.nonNull(system.getLinkToSystemId())) {
                    system.setLinkToSystemId((UUID)referencesMap.get(system.getLinkToSystemId()));
                }
                this.createSystem(newEnv.getId(), (System)system);
            }
        });
        return newEnv;
    }

    @Override
    @Transactional
    public System createSystem(UUID environmentId, System system) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        System newSys = this.systemRepository.create(environmentId, system.getName(), system.getDescription(), this.dateTimeUtil.timestampAsUtc(), userId, system.getSystemCategoryId(), system.getParametersGettingVersion(), system.getParentSystemId(), system.getServerItf(), system.getMergeByName(), system.getLinkToSystemId(), system.getExternalId(), system.getExternalName());
        system.getConnections().forEach(connection -> this.connectionRepository.create(newSys.getId(), connection.getName(), connection.getDescription(), connection.getParameters(), this.dateTimeUtil.timestampAsUtc(), userId, connection.getConnectionType(), connection.getSourceTemplateId(), connection.getServices(), connection.getSourceId()));
        return newSys;
    }

    private void createSystem(UUID environmentId, SystemTemporaryDto system) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        System newSys = this.systemRepository.create(environmentId, system.getName(), null, this.dateTimeUtil.timestampAsUtc(), userId, StringUtils.isNotBlank((CharSequence)system.getSystemCategory()) ? this.systemCategoryRepository.getByName(system.getSystemCategory()).getId() : null, null, null, null, null, null, null, null);
        system.getConnections().forEach(connection -> this.createConnection(newSys.getId(), (ConnectionTemporaryDto)connection));
    }

    private void createConnection(UUID systemId, ConnectionTemporaryDto connection) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        Connection connNew = this.connectionRepository.getConnectionTemplateByName(connection.getName());
        ConnectionParameters parameters = connection.getParameters();
        for (Map.Entry entry : parameters.entrySet()) {
            connNew.getParameters().put((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
        }
        this.connectionRepository.create(systemId, connNew.getName(), null, connNew.getParameters(), this.dateTimeUtil.timestampAsUtc(), userId, null, connNew.getId(), connNew.getServices(), connNew.getSourceId());
    }

    private void updateSystem(System system, String systemCategory, List<ConnectionTemporaryDto> connection) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        UUID systemCategoryId = StringUtils.isNotBlank((CharSequence)systemCategory) ? this.systemCategoryRepository.getByName(systemCategory).getId() : null;
        this.systemRepository.updateSystemCategory(system.getId(), systemCategoryId, this.dateTimeUtil.timestampAsUtc(), userId);
        system.getConnections().forEach(conn -> {
            Optional<ConnectionTemporaryDto> connectionUpdate = connection.stream().filter(connUpd -> connUpd.getName().equals(conn.getName())).findAny();
            if (connectionUpdate.isPresent()) {
                this.updateConnection(conn.getId(), connectionUpdate.get());
                connection.remove(connectionUpdate.get());
            }
        });
        connection.forEach(connNew -> this.createConnection(system.getId(), (ConnectionTemporaryDto)connNew));
    }

    private void updateConnection(UUID id, ConnectionTemporaryDto connection) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        Connection connUpdate = this.connectionRepository.getById(id);
        ConnectionParameters parameters = connection.getParameters();
        for (Map.Entry entry : parameters.entrySet()) {
            connUpdate.getParameters().put((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
        }
        this.connectionRepository.update(id, connUpdate.getSystemId(), connUpdate.getName(), connUpdate.getDescription(), connUpdate.getParameters(), this.dateTimeUtil.timestampAsUtc(), userId, connUpdate.getConnectionType(), connUpdate.getSourceTemplateId(), connUpdate.getServices(), connUpdate.getSourceId());
    }

    @Override
    @Nonnull
    @Transactional
    public Environment temporary(UUID id, List<SystemTemporaryDto> systemList) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        Environment sourceEnv = this.environmentRepository.getById(id);
        Preconditions.checkNotNull((Object)sourceEnv, (String)"Environment %s can't be empty", (Object)id);
        Environment temporaryEnv = this.environmentRepository.create(sourceEnv.getName() + " " + this.dateTimeUtil.dataTimeAsUtc(), sourceEnv.getGraylogName(), sourceEnv.getDescription(), sourceEnv.getSsmSolutionAlias(), sourceEnv.getSsmInstanceAlias(), sourceEnv.getConsulEgressConfigPath(), this.dateTimeUtil.timestampAsUtc(), userId, sourceEnv.getProjectId(), this.categoryId, sourceEnv.getTags());
        sourceEnv.getSystems().forEach(system -> {
            System toCopy = this.createSystem(temporaryEnv.getId(), (System)system);
            Optional<SystemTemporaryDto> toMerge = systemList.stream().filter(sysUpd -> sysUpd.getName().equals(toCopy.getName())).findAny();
            if (toMerge.isPresent()) {
                this.updateSystem(toCopy, toMerge.get().getSystemCategory(), toMerge.get().getConnections());
                systemList.remove(toMerge.get());
            }
        });
        systemList.forEach(sysNew -> this.createSystem(temporaryEnv.getId(), (SystemTemporaryDto)sysNew));
        return temporaryEnv;
    }

    @Override
    public UUID getProjectIdBySystemId(UUID systemId) {
        Preconditions.checkNotNull((Object)systemId, (Object)"System id can't be empty");
        return this.environmentRepository.getProjectIdBySystemId(systemId);
    }

    @Override
    public UUID getProjectIdByEnvironmentId(@Nonnull UUID environmentId) {
        return this.environmentRepository.getProjectIdByEnvironmentId(environmentId);
    }

    @Override
    public List<Environment> getByProjectId(@NotNull UUID projectId) {
        return this.environmentRepository.getAllByParentId(projectId);
    }

    @Override
    public Environment getByNameAndProjectId(String name, UUID projectId) {
        return this.environmentRepository.getByNameAndProjectId(name, projectId);
    }

    @Override
    public List<Environment> findBySearchRequest(BaseSearchRequestDto searchRequest) throws Exception {
        return this.environmentRepository.findBySearchRequest(searchRequest, this.projectAccessService.getProjectIdsWithAccess());
    }

    @Override
    public void update(Environment environment) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        this.update(environment.getId(), environment.getName().trim(), environment.getGraylogName(), environment.getDescription(), environment.getSsmSolutionAlias(), environment.getSsmInstanceAlias(), environment.getConsulEgressConfigPath(), environment.getProjectId(), environment.getCategoryId(), environment.getTags());
    }

    @Override
    @Transactional
    public void update(UUID id, String name, String graylogName, String description, String ssmSolutionAlias, String ssmInstanceAlias, String consulEgressConfigPath, UUID projectId, UUID categoryId, List<String> tags) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        this.environmentRepository.update(id, name.trim(), graylogName, description, ssmSolutionAlias, ssmInstanceAlias, consulEgressConfigPath, this.dateTimeUtil.timestampAsUtc(), userId, projectId, categoryId, tags);
        this.removeCacheEntriesWithEnvironment(id);
    }

    @Override
    @Transactional
    public void delete(UUID environmentId) {
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        this.environmentRepository.delete(environmentId, this.dateTimeUtil.timestampAsUtc(), userId);
        this.removeCacheEntriesWithEnvironment(environmentId);
    }

    private void removeCacheEntriesWithEnvironment(UUID environmentId) {
        this.getSystemIdsByEnvironmentCacheId(environmentId).forEach(arg_0 -> ((Cache)this.environmentsBySystemIdCachedMap).evictIfPresent(arg_0));
    }

    private List<UUID> getSystemIdsByEnvironmentCacheId(UUID environmentId) {
        return this.getSystems(environmentId).stream().map(Identified::getId).collect(Collectors.toList());
    }

    @Override
    public List<System> getSystems(UUID environmentId) {
        return this.systemRepository.getAllByParentId(environmentId);
    }

    @Override
    public List<System> getSystems(UUID environmentId, String systemType) {
        return this.systemRepository.getAllByParentId(environmentId, systemType);
    }

    @Override
    public List<System> getShortSystems(UUID environmentId) {
        return this.systemRepository.getAllShortByParentId(environmentId);
    }

    @Override
    public Collection<System> getSystemsV2(UUID environmentId) {
        log.info("Get systems for environment with id '{}'", (Object)environmentId);
        Collection<System> foundedSystems = this.systemRepository.getAllByParentIdV2(environmentId);
        log.info("Found systems with ids '{}'", foundedSystems.stream().map(Identified::getId).collect(Collectors.toList()));
        return foundedSystems;
    }

    @Override
    public Collection<System> getSystemsV2(UUID environmentId, String systemType) {
        log.info("Get systems for environment with id '{}' and type '{}'", (Object)environmentId, (Object)systemType);
        return this.systemRepository.getAllByParentIdV2(environmentId, systemType);
    }

    @Override
    public Environment getBySourceIdAndProjectId(UUID sourceId, UUID projectId) {
        log.debug("Get environment by source id '{}' and project id '{}'", (Object)sourceId, (Object)projectId);
        return this.environmentRepository.getBySourceIdAndProjectId(sourceId, projectId);
    }

    @Override
    public List<Environment> getByIds(List<UUID> environmentIds) {
        List<Environment> environments = this.environmentRepository.getByIds(environmentIds);
        return environments != null ? environments : Collections.emptyList();
    }

    @Override
    public String getHtmlVersionByEnvironments(List<UUID> environmentIds) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        List<Environment> environments = this.getByIds(environmentIds);
        if (Objects.isNull(environments) || environments.size() != environmentIds.size()) {
            return "";
        }
        ContainerTag tableTagWithVersion = TagCreator.body();
        ContainerTag table = (ContainerTag)TagCreator.table().withStyle("border-collapse: collapse;");
        for (Environment environment : environments) {
            MDC.put((String)MdcField.ENVIRONMENT_ID.toString(), (String)environment.getId().toString());
            table.with((DomContent)TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.b((String)environment.getName())})}));
            if (CollectionUtils.isEmpty((Collection)environment.getSystems())) continue;
            for (System system : environment.getSystems()) {
                ContainerTag tableLine = (ContainerTag)TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)system.getName()).withStyle("border: 1px solid rgb(0,0,0)")}).withStyle("border-collapse: collapse;");
                try {
                    String version = this.systemService.getCachedVersionBySystem(system).getVersion();
                    tableLine.with((DomContent)TagCreator.td((String)version).withStyle("border: 1px solid rgb(0,0,0)"));
                }
                catch (Exception e) {
                    String message = String.format("Error occurred while getting version of %s", system.getName());
                    log.error(message, (Throwable)e);
                    tableLine.with((DomContent)TagCreator.td((String)message).withStyle("border: 1px solid rgb(0,0,0)"));
                }
                table.with((DomContent)tableLine);
            }
        }
        tableTagWithVersion.with((DomContent)table);
        return TagCreator.html((DomContent[])new DomContent[]{tableTagWithVersion}).render();
    }

    @Override
    public ValidateTaToolsResponse validateTaTools(ValidateTaToolsRequest request) {
        this.environmentRepository.getContext().setFullDbFetching(true);
        ArrayList<ValidateTaToolResponse> toolResponses = new ArrayList<ValidateTaToolResponse>();
        ValidationStrategy strategy = this.validationStrategyFactory.createStrategy("itfLite");
        if (!CollectionUtils.isEmpty(request.getToolIds())) {
            List<Environment> taTools = this.environmentRepository.getByIds(request.getToolIds());
            toolResponses.addAll(taTools.stream().map(strategy::validate).collect(Collectors.toList()));
        }
        return new ValidateTaToolsResponse(toolResponses);
    }

    @Override
    @Nullable
    public List<Connection> getConnections(UUID environmentId) {
        return this.connectionRepository.getAllByEnvironmentId(environmentId);
    }

    @Override
    public List<Environment> getEnvironmentsByFilterRequest(EnvironmentsWithFilterRequest request, Integer page, Integer size) {
        if (CollectionUtils.isEmpty(request.getFields())) {
            throw new EnvironmentsWithFilterRequestException(request, "\nFields can not be empty");
        }
        Integer offset = null;
        if (page != null && size != null) {
            offset = (page - 1) * size;
        }
        return this.environmentRepository.getEnvironmentsByFilterPaged(request, size, offset);
    }

    @Override
    public Collection<GroupedByTagEnvironmentResponse> getGroupedByTagEnvironments(UUID projectId) {
        List<Environment> environments = this.environmentRepository.getAllShortByParentId(projectId, Constants.Environment.Category.ENVIRONMENT);
        if (CollectionUtils.isEmpty(environments)) {
            return new ArrayList<GroupedByTagEnvironmentResponse>();
        }
        HashMap resultMap = new HashMap();
        GroupedByTagEnvironmentResponse noTagResponse = new GroupedByTagEnvironmentResponse(new ArrayList<Environment>(), NO_TAG);
        for (Environment environment : environments) {
            List tags = environment.getTags();
            if (!CollectionUtils.isEmpty((Collection)tags)) {
                tags.forEach(tag -> this.processEnvironmentByTag(environment, (String)tag, resultMap));
                continue;
            }
            noTagResponse.getEnvironments().add(environment);
        }
        ArrayList<GroupedByTagEnvironmentResponse> result = new ArrayList<GroupedByTagEnvironmentResponse>(resultMap.values());
        result.add(noTagResponse);
        return result;
    }

    private void processEnvironmentByTag(Environment environment, String tag, Map<String, GroupedByTagEnvironmentResponse> resultMap) {
        if (!resultMap.containsKey(tag)) {
            resultMap.put(tag, new GroupedByTagEnvironmentResponse(new ArrayList<Environment>(), tag));
        }
        resultMap.get(tag).getEnvironments().add(environment);
    }
}

