/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import com.google.common.collect.Iterators;
import java.util.List;
import java.util.stream.Collectors;
import org.qubership.atp.environments.model.response.JaversCountResponse;
import org.qubership.atp.environments.model.response.JaversVersionResponse;
import org.qubership.atp.environments.repo.impl.JaversCommitPropertyRepositoryImpl;
import org.qubership.atp.environments.repo.impl.JaversCommitRepositoryImpl;
import org.qubership.atp.environments.repo.impl.JaversGlobalIdRepositoryImpl;
import org.qubership.atp.environments.repo.impl.JaversSnapshotRepositoryImpl;
import org.qubership.atp.environments.service.direct.JaversSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="javersSnapshotService")
public class JaversSnapshotServiceImpl
implements JaversSnapshotService {
    private static final Logger log = LoggerFactory.getLogger(JaversSnapshotServiceImpl.class);
    @Value(value="${atp-environments.archive.job.bulk-delete-count}")
    private Integer bulkDeleteCount;
    private final JaversSnapshotRepositoryImpl javersSnapshotRepository;
    private final JaversCommitRepositoryImpl javersCommitRepository;
    private final JaversCommitPropertyRepositoryImpl javersCommitPropertyRepository;
    private final JaversGlobalIdRepositoryImpl javersGlobalIdRepository;

    @Autowired
    public JaversSnapshotServiceImpl(JaversSnapshotRepositoryImpl repository, JaversCommitRepositoryImpl javersCommitRepository, JaversCommitPropertyRepositoryImpl javersCommitPropertyRepository, JaversGlobalIdRepositoryImpl javersGlobalIdRepository) {
        this.javersSnapshotRepository = repository;
        this.javersCommitRepository = javersCommitRepository;
        this.javersCommitPropertyRepository = javersCommitPropertyRepository;
        this.javersGlobalIdRepository = javersGlobalIdRepository;
    }

    @Override
    public List<JaversCountResponse> getGlobalIdAndCount(Integer lastRevisionCount) {
        List<JaversCountResponse> globalIdAndCount = this.javersSnapshotRepository.getGlobalIdAndCount(lastRevisionCount);
        log.debug("Number of unique globalId '{}'", (Object)globalIdAndCount.size());
        return globalIdAndCount;
    }

    @Override
    public List<JaversVersionResponse> getOld(Long globalId, Long count) {
        List<JaversVersionResponse> snapshots = this.javersSnapshotRepository.getOld(globalId, count);
        log.debug("Number of old snapshots '{}' for globalId '{}'", (Object)snapshots.size(), (Object)globalId);
        return snapshots;
    }

    @Override
    @Transactional
    public void deleteOldAndUpdateAsInitial(Long version, Long globalId, Long commitId) {
        this.javersSnapshotRepository.deleteByVersionAndGlobalIdAndCommitId(version, globalId, commitId);
        log.debug("Deleted snapshots with version '{}', globalId '{}' and commitId '{}'.", new Object[]{version, globalId, commitId});
        Long commitCount = this.javersSnapshotRepository.getCountByCommitId(commitId);
        if (commitCount == 0L) {
            this.javersCommitPropertyRepository.deleteByCommitId(commitId);
            this.javersCommitRepository.deleteByCommitId(commitId);
            log.debug("Deleted commit properties and commits with commitId '{}'", (Object)commitId);
        }
        this.javersSnapshotRepository.updateAsInitial(globalId);
    }

    @Override
    @Transactional
    public void deleteTerminatedSnapshots() {
        List<JaversVersionResponse> terminatedSnapshots = this.javersSnapshotRepository.getTerminatedSnapshots();
        List globalIds = terminatedSnapshots.stream().map(JaversVersionResponse::getGlobalId).distinct().collect(Collectors.toList());
        List commitIds = terminatedSnapshots.stream().map(JaversVersionResponse::getCommitId).collect(Collectors.toList());
        log.debug("Number of terminated globalIds '{}', commitIds '{}'", (Object)globalIds.size(), (Object)commitIds.size());
        Iterators.partition(globalIds.iterator(), (int)this.bulkDeleteCount).forEachRemaining(this.javersSnapshotRepository::deleteByGlobalIds);
        log.debug("Terminated snapshots deleted");
        Iterators.partition(globalIds.iterator(), (int)this.bulkDeleteCount).forEachRemaining(this.javersGlobalIdRepository::deleteByGlobalIds);
        log.debug("Terminated globalIds deleted");
        Iterators.partition(commitIds.iterator(), (int)this.bulkDeleteCount).forEachRemaining(this.javersCommitPropertyRepository::deleteByCommitIds);
        log.debug("Terminated commit properties deleted");
        Iterators.partition(commitIds.iterator(), (int)this.bulkDeleteCount).forEachRemaining(this.javersCommitRepository::deleteByCommitIds);
        log.debug("Terminated commits deleted");
    }
}

