/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.UUID;
import org.qubership.atp.environments.service.direct.KafkaService;
import org.qubership.atp.environments.service.notification.EventNotificationService;
import org.qubership.atp.environments.service.rest.server.dto.EventType;
import org.qubership.atp.environments.service.rest.server.dto.ProducerNotificationEvent;
import org.springframework.stereotype.Service;

@Service
public class KafkaServiceImpl
implements KafkaService {
    private final EventNotificationService systemEventNotificationService;
    private final EventNotificationService environmentEventNotificationService;
    private final EventNotificationService connectionEventNotificationService;

    @Override
    public void sendConnectionKafkaNotification(UUID connectionId, EventType connectionEventType, UUID projectId) {
        this.connectionEventNotificationService.notify(new ProducerNotificationEvent(connectionId, connectionEventType, projectId));
    }

    @Override
    public void sendSystemKafkaNotification(UUID systemId, EventType systemEventType, UUID projectId) {
        this.systemEventNotificationService.notify(new ProducerNotificationEvent(systemId, systemEventType, projectId));
    }

    @Override
    public void sendEnvironmentKafkaNotification(UUID environmentId, EventType environmentEventType, UUID projectId) {
        this.environmentEventNotificationService.notify(new ProducerNotificationEvent(environmentId, environmentEventType, projectId));
    }

    public KafkaServiceImpl(EventNotificationService systemEventNotificationService, EventNotificationService environmentEventNotificationService, EventNotificationService connectionEventNotificationService) {
        this.systemEventNotificationService = systemEventNotificationService;
        this.environmentEventNotificationService = environmentEventNotificationService;
        this.connectionEventNotificationService = connectionEventNotificationService;
    }
}

