/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MetricService {
    private static final Logger log = LoggerFactory.getLogger(MetricService.class);
    private final MeterRegistry meterRegistry;
    private static final String IP_ADDR = "ip_address";
    private static final String URI = "uri";
    private static final String REQUESTS_TOTAL = "requests_by_ip";

    public void requestToService(String ipAddr, String uri) {
        this.incrementMetric(REQUESTS_TOTAL, ipAddr, uri);
    }

    private void incrementMetric(String name, String ipAddr, String uri) {
        this.meterRegistry.counter(name, new String[]{IP_ADDR, ipAddr, URI, uri}).increment();
    }

    public Timer checkVersionTimer(String ... tags) {
        return this.meterRegistry.timer("atp.environments.check.version.duration", tags);
    }

    public MetricService(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }
}

