/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.model.Subscriber;
import org.qubership.atp.environments.model.impl.SubscriberImpl;
import org.qubership.atp.environments.service.direct.SubscriberService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/subscribers"})
@RestController
public class SubscriberController {
    private final SubscriberService subscriberService;

    @Autowired
    public SubscriberController(SubscriberService service) {
        this.subscriberService = service;
    }

    @GetMapping(value={"/{subscriberId}"})
    @AuditAction(auditAction="Get subscriber by id {{#uuid.toString()}}")
    public Subscriber getsubscriber(@PathVariable(value="subscriberId") UUID uuid) {
        return (Subscriber)this.subscriberService.get(uuid);
    }

    @PostMapping
    @AuditAction(auditAction="Create subscriber by id {{#subscriber.getId()}}")
    public Subscriber create(@RequestBody SubscriberImpl subscriber) {
        return this.subscriberService.create((Subscriber)subscriber);
    }

    @PutMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Update subscriber by id {{#subscriber.getId()}}")
    public void update(@RequestBody SubscriberImpl subscriber) {
        Preconditions.checkNotNull((Object)subscriber.getId(), (Object)"Subscriber id can't be empty");
        Preconditions.checkNotNull((Object)subscriber.getName(), (Object)"Subscriber name can't be empty");
        this.subscriberService.update((Subscriber)subscriber);
    }

    @GetMapping
    @AuditAction(auditAction="Get all subscribers")
    public List<Subscriber> getAll() {
        return this.subscriberService.getAll();
    }

    @DeleteMapping(value={"/{subscriberId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete subscriber by id {{#subscriberId.toString()}}")
    public void delete(@PathVariable(value="subscriberId") UUID subscriberId) {
        this.subscriberService.delete(subscriberId);
    }
}

