/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.utils;

import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Converter {
    private static final Logger log = LoggerFactory.getLogger(Converter.class);
    protected static final ModelMapper INTERNAL_MAPPER = new ModelMapper();

    public <T> T convert(Object from, Class<T> to) {
        return (T)INTERNAL_MAPPER.map(from, to);
    }

    public <T> List<T> convertList(List from, Class<T> to) {
        if (from == null) {
            return new ArrayList();
        }
        return from.stream().map(o -> this.convert(o, to)).collect(Collectors.toList());
    }

    static {
        INTERNAL_MAPPER.getConfiguration().getConverters().add(new Timestamp2OffsetDateTimeConverter());
        INTERNAL_MAPPER.getConfiguration().getConverters().add(new OffsetDateTime2TimestampConverter());
    }

    public static class Timestamp2OffsetDateTimeConverter
    implements ConditionalConverter<Timestamp, OffsetDateTime> {
        public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
            if (Timestamp.class.isAssignableFrom(sourceType) && OffsetDateTime.class.isAssignableFrom(destinationType)) {
                return ConditionalConverter.MatchResult.FULL;
            }
            return ConditionalConverter.MatchResult.NONE;
        }

        public OffsetDateTime convert(MappingContext<Timestamp, OffsetDateTime> context) {
            if (context.getSource() == null) {
                return null;
            }
            return OffsetDateTime.ofInstant(((Timestamp)context.getSource()).toInstant(), ZoneOffset.UTC);
        }
    }

    public static class OffsetDateTime2TimestampConverter
    implements ConditionalConverter<OffsetDateTime, Timestamp> {
        public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
            if (OffsetDateTime.class.isAssignableFrom(sourceType) && Timestamp.class.isAssignableFrom(destinationType)) {
                return ConditionalConverter.MatchResult.FULL;
            }
            return ConditionalConverter.MatchResult.NONE;
        }

        public Timestamp convert(MappingContext<OffsetDateTime, Timestamp> context) {
            if (context.getSource() == null) {
                return null;
            }
            return new Timestamp(((OffsetDateTime)context.getSource()).toEpochSecond());
        }
    }
}

