/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reader<R, A>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Reader.class);
    public static final String NO_RESPONSE_FROM_REMOTE_SERVER = "No response from remote server";
    private static final int readAttempts = 600;
    private final InputStream is;
    private final byte[] buffer = new byte[1024];
    private final Collector<? super String, A, R> collector;
    private A collection;

    public Reader(InputStream is, Collector<? super String, A, R> collector) {
        this.is = is;
        this.collector = collector;
    }

    public static <R> Reader<R, ?> create(InputStream is, Collector<? super String, ?, R> collector) {
        return new Reader(is, collector);
    }

    public static <R> Optional<R> readInput(Supplier<Boolean> shouldStop, InputStream is, InputStream err, Collector<? super String, ?, R> collector) throws IOException, TimeoutException {
        Reader<R, ?> contentReader = Reader.create(is, collector);
        Reader<String, ?> errorReader = Reader.create(err, Collectors.joining());
        AtomicInteger counter = new AtomicInteger(600);
        while (true) {
            if (!errorReader.readAttempt() && !contentReader.readAttempt()) {
                if (BooleanUtils.isTrue((Boolean)shouldStop.get())) break;
                if (counter.getAndDecrement() == 0) {
                    throw new TimeoutException(NO_RESPONSE_FROM_REMOTE_SERVER);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.error("Thead was interrupted: ", (Throwable)e);
                }
                continue;
            }
            counter.set(600);
        }
        errorReader.flush().ifPresent(message -> {
            throw new IllegalArgumentException((String)message);
        });
        return contentReader.flush();
    }

    public static void closeQuietly(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean readAttempt() throws IOException {
        if (this.is.available() <= 0) {
            return false;
        }
        int i = this.is.read(this.buffer, 0, 1024);
        return this.acceptChunk(i);
    }

    public boolean fileReadAttempt() throws IOException {
        int i = this.is.read(this.buffer, 0, 1024);
        if (this.acceptChunk(i)) {
            return true;
        }
        throw new InterruptedIOException("EoF");
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    private boolean acceptChunk(int i) {
        if (i >= 0) {
            String chunk = new String(this.buffer, 0, i);
            if (this.collection == null) {
                this.collection = this.collector.supplier().get();
            }
            this.collector.accumulator().accept(this.collection, chunk);
            return true;
        }
        return false;
    }

    public Optional<R> flush() throws IOException {
        boolean hasData;
        while (hasData = this.readAttempt()) {
        }
        Reader.closeQuietly(this.is);
        return Optional.ofNullable(this.collection).map(c -> this.collector.finisher().apply(c));
    }

    @Override
    public void close() {
        Reader.closeQuietly(this.is);
    }
}

