/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.validating.strategies;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.service.rest.server.response.ValidateTaToolResponse;
import org.qubership.atp.environments.validating.strategies.ValidationStrategy;
import org.springframework.stereotype.Component;

@Component(value="itfLite")
public class ItlLiteTaToolStrategy
implements ValidationStrategy {
    @Override
    public ValidateTaToolResponse validate(Environment taTool) {
        ValidateTaToolResponse response = new ValidateTaToolResponse();
        response.setId(taTool.getId());
        response.setName(taTool.getName());
        response.setValidated(false);
        System itfLiteSystem = this.findSystemByCategory(taTool.getSystems(), Constants.SystemCategories.ITF_LITE);
        if (itfLiteSystem == null) {
            response.setMessage("A Tool entity has to contain system with category 'ITF Lite' and this system has to contain 'HTTP' connection and 'HTTP' connection has to contain 'URL' property");
            return response;
        }
        Connection httpConnection = this.findConnectionByTemplateId(itfLiteSystem.getConnections(), Constants.Environment.System.Connection.HTTP);
        if (httpConnection == null) {
            response.setMessage("'ITF Lite' System has to contain 'HTTP' connection and 'HTTP' connection has to contain 'URL' property");
            return response;
        }
        if (MapUtils.isEmpty((Map)httpConnection.getParameters()) || StringUtils.isBlank((CharSequence)((CharSequence)httpConnection.getParameters().get((Object)"url")))) {
            response.setMessage("'HTTP' connection has to contain 'URL' property");
            return response;
        }
        response.setValidated(true);
        return response;
    }

    public System findSystemByCategory(List<System> systems, UUID categoryId) {
        if (!CollectionUtils.isEmpty(systems)) {
            return systems.stream().filter(system -> system.getSystemCategory() != null && system.getSystemCategory().getId().equals(categoryId)).findFirst().orElse(null);
        }
        return null;
    }

    public Connection findConnectionByTemplateId(List<Connection> connections, UUID templateId) {
        if (!CollectionUtils.isEmpty(connections)) {
            return connections.stream().filter(connection -> connection.getSourceTemplateId() != null && connection.getSourceTemplateId().equals(templateId)).findFirst().orElse(null);
        }
        return null;
    }
}

