/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.version.checkers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.qubership.atp.environments.errorhandling.clients.EnvironmentKuberClientConfigMapFetchException;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.utils.enums.TypeGettingVersion;
import org.qubership.atp.environments.utils.cloud.KubeClient;
import org.qubership.atp.environments.version.checkers.VersionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeVersionChecker
implements VersionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubeVersionChecker.class);
    private String server;
    private String token;
    private String mapName;
    private String namespace;
    private String login;
    private String password;
    private TypeGettingVersion gettingType;

    @Override
    public String getVersion() {
        String version;
        KubeClient kubeClient = KubeClient.createKubeClient(this.server, this.token, this.login, this.password, this.namespace);
        try {
            if (this.gettingType == TypeGettingVersion.BY_KUBERNETES_CONFIGMAP) {
                Map configMap = Objects.requireNonNull(kubeClient.getConfigMap(this.mapName).getData());
                Gson gson = new Gson();
                JsonElement json = gson.toJsonTree((Object)configMap);
                version = new GsonBuilder().setPrettyPrinting().create().toJson(json);
            } else {
                Set<String> images = kubeClient.getImages();
                version = String.join((CharSequence)"\n", images);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to get config map with name {}, namespace {} from kuber client", new Object[]{this.mapName, this.namespace, e});
            throw new EnvironmentKuberClientConfigMapFetchException(this.mapName, this.namespace);
        }
        return version;
    }

    @Override
    public void setConnectionParameters(Connection parameters) {
        this.server = (String)parameters.getParameters().get((Object)"url");
        this.token = (String)parameters.getParameters().get((Object)"token");
        this.mapName = "version";
        this.namespace = (String)parameters.getParameters().get((Object)"namespace");
        this.login = (String)parameters.getParameters().get((Object)"login");
        this.password = (String)parameters.getParameters().get((Object)"password");
    }

    public void setGettingType(TypeGettingVersion type) {
        this.gettingType = type;
    }

    @Override
    public void setParametersVersionCheck(String parameters) {
    }
}

