/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.version.checkers;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.ParametersGettingVersion;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.model.utils.enums.TypeGettingVersion;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.qubership.atp.environments.service.direct.DecryptorService;
import org.qubership.atp.environments.version.checkers.DbVersionChecker;
import org.qubership.atp.environments.version.checkers.HttpVersionChecker;
import org.qubership.atp.environments.version.checkers.KubeVersionChecker;
import org.qubership.atp.environments.version.checkers.OpenshiftVersionChecker;
import org.qubership.atp.environments.version.checkers.SshVersionChecker;
import org.qubership.atp.environments.version.checkers.SsmVersionChecker;
import org.qubership.atp.environments.version.checkers.VersionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class VersionCheckerFactory {
    private static final Logger log = LoggerFactory.getLogger(VersionCheckerFactory.class);
    private final DecryptorService decryptorService;
    private final CloseableHttpClient httpClient;
    private final SystemRepositoryImpl systemRepository;
    @Value(value="${atp-environments.ssh.session.timeout.seconds}")
    private String sshSessionTimeout;
    private static final String SSM_CATEGORY_NAME = "SSM";

    public VersionChecker createChecker(System system) {
        if (system != null && system.getParametersGettingVersion() != null) {
            VersionChecker checker;
            ParametersGettingVersion parametersGettingVersion = system.getParametersGettingVersion();
            TypeGettingVersion type = parametersGettingVersion.getType();
            switch (type) {
                case BY_SQL_QUERY: {
                    checker = new DbVersionChecker();
                    break;
                }
                case BY_SHELL_SCRIPT: {
                    checker = new SshVersionChecker();
                    ((SshVersionChecker)checker).setSessionTimeout(this.sshSessionTimeout);
                    break;
                }
                case BY_KUBERNETES_IMAGES: 
                case BY_KUBERNETES_CONFIGMAP: {
                    checker = new KubeVersionChecker();
                    ((KubeVersionChecker)checker).setGettingType(type);
                    break;
                }
                case BY_OPENSHIFT_CONFIGURATION: {
                    OpenshiftVersionChecker checker2 = new OpenshiftVersionChecker();
                    List<Connection> openShiftConnections = this.getAllConnectionsByType(system, type.getListValueId());
                    Preconditions.checkState((!CollectionUtils.isEmpty(openShiftConnections) ? 1 : 0) != 0, (Object)"No Openshift connection found");
                    for (Connection connection2 : openShiftConnections) {
                        checker2.setConnectionParameters(this.decryptorService.decryptConnection(connection2));
                    }
                    return checker2;
                }
                case BY_HTTP_ENDPOINT: {
                    checker = new HttpVersionChecker(this.httpClient);
                    break;
                }
                case BY_HTTP_ENDPOINT_BASIC_AUTH: {
                    checker = new HttpVersionChecker(this.httpClient);
                    ((HttpVersionChecker)checker).setAuthorization();
                    ((HttpVersionChecker)checker).setJsonHeaders(parametersGettingVersion.getHeaders());
                    break;
                }
                case BY_SSM: {
                    log.debug("check version by SSM");
                    log.debug("searching for a system with SSM category and HTTP connection");
                    for (Environment env : system.getEnvironments()) {
                        String solutionAlias = env.getSsmSolutionAlias();
                        String instanceAlias = env.getSsmInstanceAlias();
                        List<System> systems = this.systemRepository.getAllByParentId(env.getId(), SSM_CATEGORY_NAME);
                        if (StringUtils.isEmpty((Object)solutionAlias) || StringUtils.isEmpty((Object)instanceAlias) || CollectionUtils.isEmpty(systems)) continue;
                        for (System sys : systems) {
                            Optional<Connection> conn = sys.getConnections().stream().filter(connection -> connection.getSourceTemplateId() != null && connection.getSourceTemplateId().equals(Constants.Environment.System.Connection.HTTP)).findFirst();
                            if (!conn.isPresent()) continue;
                            log.info("System with SSM category found. SystemId: [{}]", (Object)sys.getId());
                            SsmVersionChecker checker3 = new SsmVersionChecker(this.httpClient);
                            checker3.setSystemName(system.getName());
                            checker3.setSsmSolutionAlias(solutionAlias);
                            checker3.setSsmInstanceAlias(instanceAlias);
                            checker3.setConnectionParameters(this.decryptorService.decryptConnection(conn.get()));
                            return checker3;
                        }
                    }
                    log.warn("No system with SSM category and HTTP connection found");
                    return null;
                }
                default: {
                    return null;
                }
            }
            Connection connection3 = this.getConnectionByType(system, type.getListValueId());
            Preconditions.checkState((connection3 != null && !MapUtils.isEmpty((Map)connection3.getParameters()) ? 1 : 0) != 0, (Object)(type.getConnectionNameByGettingType() + " connection parameters can't be empty"));
            checker.setConnectionParameters(this.decryptorService.decryptConnection(connection3));
            checker.setParametersVersionCheck(parametersGettingVersion.getParameters());
            return checker;
        }
        return null;
    }

    private Connection getConnectionByType(System system, UUID connectionType) {
        return system.getConnections().stream().filter(connection -> connection.getSourceTemplateId() != null && connection.getSourceTemplateId().equals(connectionType)).findFirst().orElseThrow(() -> new RuntimeException(String.format("Connection with type [ID:%s] not found", connectionType)));
    }

    private List<Connection> getAllConnectionsByType(System system, UUID connectionType) {
        return system.getConnections().stream().filter(connection -> connection.getSourceTemplateId() != null && connection.getSourceTemplateId().equals(connectionType)).collect(Collectors.toList());
    }

    public VersionCheckerFactory(DecryptorService decryptorService, CloseableHttpClient httpClient, SystemRepositoryImpl systemRepository) {
        this.decryptorService = decryptorService;
        this.httpClient = httpClient;
        this.systemRepository = systemRepository;
    }
}

