/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class EntryListIntegerLongCodec {
    private static final int ENTRY_SIZE_IN_BYTES = 12;

    private EntryListIntegerLongCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Map.Entry<Integer, Long>> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 12]);
        Iterator<Map.Entry<Integer, Long>> iterator = collection.iterator();
        for (int i = 0; i < itemCount; ++i) {
            Map.Entry<Integer, Long> entry = iterator.next();
            FixedSizeTypesCodec.encodeInt(frame.content, i * 12, entry.getKey());
            FixedSizeTypesCodec.encodeLong(frame.content, i * 12 + 4, entry.getValue());
        }
        clientMessage.add(frame);
    }

    public static List<Map.Entry<Integer, Long>> decode(ClientMessage.ForwardFrameIterator iterator) {
        ClientMessage.Frame frame = iterator.next();
        int itemCount = frame.content.length / 12;
        ArrayList<Map.Entry<Integer, Long>> result = new ArrayList<Map.Entry<Integer, Long>>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            int key = FixedSizeTypesCodec.decodeInt(frame.content, i * 12);
            long value = FixedSizeTypesCodec.decodeLong(frame.content, i * 12 + 4);
            result.add(new AbstractMap.SimpleEntry<Integer, Long>(key, value));
        }
        return result;
    }
}

