/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCGetMapConfigCodec;
import com.hazelcast.client.impl.protocol.task.AbstractInvocationMessageTask;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.config.MapConfigReadOnly;
import com.hazelcast.internal.management.operation.GetMapConfigOperation;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.ManagementPermission;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;

public class GetMapConfigMessageTask
extends AbstractInvocationMessageTask<String> {
    private static final Permission REQUIRED_PERMISSION = new ManagementPermission("map.getConfig");

    public GetMapConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        return this.nodeEngine.getOperationService().createInvocationBuilder(this.getServiceName(), op, this.nodeEngine.getThisAddress());
    }

    @Override
    protected Operation prepareOperation() {
        return new GetMapConfigOperation((String)this.parameters);
    }

    @Override
    protected String decodeClientMessage(ClientMessage clientMessage) {
        return MCGetMapConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        MapConfigReadOnly config = (MapConfigReadOnly)response;
        EvictionConfig evictionConfig = config.getEvictionConfig();
        int maxSize = evictionConfig.getSize();
        int maxSizePolicyId = evictionConfig.getMaxSizePolicy().getId();
        int evictionPolicyId = evictionConfig.getEvictionPolicy().getId();
        String mergePolicy = config.getMergePolicyConfig().getPolicy();
        return MCGetMapConfigCodec.encodeResponse(config.getInMemoryFormat().getId(), config.getBackupCount(), config.getAsyncBackupCount(), config.getTimeToLiveSeconds(), config.getMaxIdleSeconds(), maxSize, maxSizePolicyId, config.isReadBackupData(), evictionPolicyId, mergePolicy);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return REQUIRED_PERMISSION;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getMapConfig";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.parameters};
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

