/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlTypeNameSpec;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.util.Litmus;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.Objects;

public class SqlCollectionTypeNameSpec
extends SqlTypeNameSpec {
    private final SqlTypeNameSpec elementTypeName;
    private final SqlTypeName collectionTypeName;

    public SqlCollectionTypeNameSpec(SqlTypeNameSpec elementTypeName, SqlTypeName collectionTypeName, SqlParserPos pos) {
        super(new SqlIdentifier(collectionTypeName.name(), pos), pos);
        this.elementTypeName = Objects.requireNonNull(elementTypeName);
        this.collectionTypeName = Objects.requireNonNull(collectionTypeName);
    }

    public SqlTypeNameSpec getElementTypeName() {
        return this.elementTypeName;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator) {
        RelDataType type = this.elementTypeName.deriveType(validator);
        return this.createCollectionType(type, validator.getTypeFactory());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.elementTypeName.unparse(writer, leftPrec, rightPrec);
        writer.keyword(this.collectionTypeName.name());
    }

    @Override
    public boolean equalsDeep(SqlTypeNameSpec spec, Litmus litmus) {
        if (!(spec instanceof SqlCollectionTypeNameSpec)) {
            return litmus.fail("{} != {}", this, spec);
        }
        SqlCollectionTypeNameSpec that = (SqlCollectionTypeNameSpec)spec;
        if (!this.elementTypeName.equalsDeep(that.elementTypeName, litmus)) {
            return litmus.fail("{} != {}", this, spec);
        }
        if (!Objects.equals((Object)this.collectionTypeName, (Object)that.collectionTypeName)) {
            return litmus.fail("{} != {}", this, spec);
        }
        return litmus.succeed();
    }

    private RelDataType createCollectionType(RelDataType elementType, RelDataTypeFactory typeFactory) {
        switch (this.collectionTypeName) {
            case MULTISET: {
                return typeFactory.createMultisetType(elementType, -1L);
            }
            case ARRAY: {
                return typeFactory.createArrayType(elementType, -1L);
            }
        }
        throw Util.unexpected(this.collectionTypeName);
    }
}

