/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSelectKeyword;
import com.hazelcast.org.apache.calcite.sql.SqlSelectOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlSelect
extends SqlCall {
    public static final int FROM_OPERAND = 2;
    public static final int WHERE_OPERAND = 3;
    public static final int HAVING_OPERAND = 5;
    SqlNodeList keywordList;
    SqlNodeList selectList;
    SqlNode from;
    SqlNode where;
    SqlNodeList groupBy;
    SqlNode having;
    SqlNodeList windowDecls;
    SqlNodeList orderBy;
    SqlNode offset;
    SqlNode fetch;
    SqlNodeList hints;

    public SqlSelect(SqlParserPos pos, SqlNodeList keywordList, SqlNodeList selectList, SqlNode from, SqlNode where, SqlNodeList groupBy, SqlNode having, SqlNodeList windowDecls, SqlNodeList orderBy, SqlNode offset, SqlNode fetch, SqlNodeList hints) {
        super(pos);
        this.keywordList = Objects.requireNonNull(keywordList != null ? keywordList : new SqlNodeList(pos));
        this.selectList = selectList;
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.windowDecls = Objects.requireNonNull(windowDecls != null ? windowDecls : new SqlNodeList(pos));
        this.orderBy = orderBy;
        this.offset = offset;
        this.fetch = fetch;
        this.hints = hints;
    }

    @Override
    public SqlOperator getOperator() {
        return SqlSelectOperator.INSTANCE;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.SELECT;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.keywordList, this.selectList, this.from, this.where, this.groupBy, this.having, this.windowDecls, this.orderBy, new SqlNode[]{this.offset, this.fetch, this.hints});
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.keywordList = Objects.requireNonNull((SqlNodeList)operand);
                break;
            }
            case 1: {
                this.selectList = (SqlNodeList)operand;
                break;
            }
            case 2: {
                this.from = operand;
                break;
            }
            case 3: {
                this.where = operand;
                break;
            }
            case 4: {
                this.groupBy = (SqlNodeList)operand;
                break;
            }
            case 5: {
                this.having = operand;
                break;
            }
            case 6: {
                this.windowDecls = Objects.requireNonNull((SqlNodeList)operand);
                break;
            }
            case 7: {
                this.orderBy = (SqlNodeList)operand;
                break;
            }
            case 8: {
                this.offset = operand;
                break;
            }
            case 9: {
                this.fetch = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public final boolean isDistinct() {
        return this.getModifierNode(SqlSelectKeyword.DISTINCT) != null;
    }

    public final SqlNode getModifierNode(SqlSelectKeyword modifier) {
        for (SqlNode keyword : this.keywordList) {
            SqlSelectKeyword keyword2 = ((SqlLiteral)keyword).symbolValue(SqlSelectKeyword.class);
            if (keyword2 != modifier) continue;
            return keyword;
        }
        return null;
    }

    public final SqlNode getFrom() {
        return this.from;
    }

    public void setFrom(SqlNode from) {
        this.from = from;
    }

    public final SqlNodeList getGroup() {
        return this.groupBy;
    }

    public void setGroupBy(SqlNodeList groupBy) {
        this.groupBy = groupBy;
    }

    public final SqlNode getHaving() {
        return this.having;
    }

    public void setHaving(SqlNode having) {
        this.having = having;
    }

    public final SqlNodeList getSelectList() {
        return this.selectList;
    }

    public void setSelectList(SqlNodeList selectList) {
        this.selectList = selectList;
    }

    public final SqlNode getWhere() {
        return this.where;
    }

    public void setWhere(SqlNode whereClause) {
        this.where = whereClause;
    }

    @Nonnull
    public final SqlNodeList getWindowList() {
        return this.windowDecls;
    }

    public final SqlNodeList getOrderList() {
        return this.orderBy;
    }

    public void setOrderBy(SqlNodeList orderBy) {
        this.orderBy = orderBy;
    }

    public final SqlNode getOffset() {
        return this.offset;
    }

    public void setOffset(SqlNode offset) {
        this.offset = offset;
    }

    public final SqlNode getFetch() {
        return this.fetch;
    }

    public void setFetch(SqlNode fetch) {
        this.fetch = fetch;
    }

    public void setHints(SqlNodeList hints) {
        this.hints = hints;
    }

    public SqlNodeList getHints() {
        return this.hints;
    }

    public boolean hasHints() {
        return this.hints != null && this.hints.size() > 0;
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateQuery(this, scope, validator.getUnknownType());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (!writer.inQuery()) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SUB_QUERY, "(", ")");
            writer.getDialect().unparseCall(writer, this, 0, 0);
            writer.endList(frame);
        } else {
            writer.getDialect().unparseCall(writer, this, leftPrec, rightPrec);
        }
    }

    public boolean hasOrderBy() {
        return this.orderBy != null && this.orderBy.size() != 0;
    }

    public boolean hasWhere() {
        return this.where != null;
    }

    public boolean isKeywordPresent(SqlSelectKeyword targetKeyWord) {
        return this.getModifierNode(targetKeyWord) != null;
    }
}

