/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.com.google.common.cache.CacheBuilder;
import com.hazelcast.com.google.common.cache.CacheLoader;
import com.hazelcast.com.google.common.cache.LoadingCache;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.ImmutableSet;
import com.hazelcast.org.apache.calcite.prepare.CalciteCatalogReader;
import com.hazelcast.org.apache.calcite.runtime.GeoFunctions;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.fun.LibraryOperator;
import com.hazelcast.org.apache.calcite.sql.fun.SqlLibrary;
import com.hazelcast.org.apache.calcite.sql.fun.SqlLibraryOperators;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.util.ListSqlOperatorTable;
import com.hazelcast.org.apache.calcite.util.Util;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class SqlLibraryOperatorTableFactory {
    private final ImmutableList<Class> classes;
    public static final SqlLibraryOperatorTableFactory INSTANCE = new SqlLibraryOperatorTableFactory(SqlLibraryOperators.class);
    private final LoadingCache<ImmutableSet<SqlLibrary>, SqlOperatorTable> cache = CacheBuilder.newBuilder().build(CacheLoader.from(this::create));

    private SqlLibraryOperatorTableFactory(Class ... classes) {
        this.classes = ImmutableList.copyOf(classes);
    }

    private SqlOperatorTable create(ImmutableSet<SqlLibrary> librarySet) {
        ImmutableList.Builder list = ImmutableList.builder();
        boolean custom = false;
        boolean standard = false;
        block6: for (SqlLibrary library : librarySet) {
            switch (library) {
                case STANDARD: {
                    standard = true;
                    continue block6;
                }
                case SPATIAL: {
                    list.addAll(CalciteCatalogReader.operatorTable(GeoFunctions.class.getName()).getOperatorList());
                    continue block6;
                }
            }
            custom = true;
        }
        if (custom) {
            for (Class aClass : this.classes) {
                for (Field field : aClass.getFields()) {
                    try {
                        SqlOperator op;
                        if (!SqlOperator.class.isAssignableFrom(field.getType()) || !this.operatorIsInLibrary((op = (SqlOperator)field.get(this)).getName(), field, librarySet)) continue;
                        list.add(op);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        Util.throwIfUnchecked(e.getCause());
                        throw new RuntimeException(e.getCause());
                    }
                }
            }
        }
        SqlOperatorTable operatorTable = new ListSqlOperatorTable((List<SqlOperator>)((Object)list.build()));
        if (standard) {
            operatorTable = ChainedSqlOperatorTable.of(SqlStdOperatorTable.instance(), operatorTable);
        }
        return operatorTable;
    }

    private boolean operatorIsInLibrary(String operatorName, Field field, Set<SqlLibrary> seekLibrarySet) {
        LibraryOperator libraryOperator = field.getAnnotation(LibraryOperator.class);
        if (libraryOperator == null) {
            throw new AssertionError((Object)("Operator must have annotation: " + operatorName));
        }
        SqlLibrary[] librarySet = libraryOperator.libraries();
        if (librarySet.length <= 0) {
            throw new AssertionError((Object)("Operator must belong to at least one library: " + operatorName));
        }
        for (SqlLibrary library : librarySet) {
            if (!seekLibrarySet.contains((Object)library)) continue;
            return true;
        }
        return false;
    }

    public SqlOperatorTable getOperatorTable(SqlLibrary ... libraries) {
        return this.getOperatorTable(ImmutableSet.copyOf(libraries));
    }

    public SqlOperatorTable getOperatorTable(Iterable<SqlLibrary> librarySet) {
        try {
            return this.cache.get(ImmutableSet.copyOf(librarySet));
        }
        catch (ExecutionException e) {
            Util.throwIfUnchecked(e.getCause());
            throw new RuntimeException("populating SqlOperatorTable for library " + librarySet, e);
        }
    }
}

