/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical;

import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTrait;
import com.hazelcast.sql.impl.calcite.opt.logical.ValuesLogicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.ValuesPhysicalRel;

public final class ValuesPhysicalRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new ValuesPhysicalRule();

    private ValuesPhysicalRule() {
        super(OptUtils.single(ValuesLogicalRel.class, HazelcastConventions.LOGICAL), ValuesPhysicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ValuesLogicalRel logicalValues = (ValuesLogicalRel)call.rel(0);
        DistributionTrait distribution = logicalValues.getHazelcastCluster().getDistributionTraitDef().getTraitReplicated();
        ValuesPhysicalRel transformedValues = new ValuesPhysicalRel(logicalValues.getCluster(), logicalValues.getRowType(), logicalValues.getTuples(), OptUtils.toPhysicalConvention(logicalValues.getTraitSet(), distribution));
        call.transformTo(transformedValues);
    }
}

