/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNode;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.plan.node.PlanNodeVisitor;
import com.hazelcast.sql.impl.plan.node.UniInputPlanNode;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ProjectPlanNode
extends UniInputPlanNode
implements IdentifiedDataSerializable {
    private List<Expression> projects;

    public ProjectPlanNode() {
    }

    public ProjectPlanNode(int id, PlanNode upstream, List<Expression> projects) {
        super(id, upstream);
        this.projects = projects;
    }

    public List<Expression> getProjects() {
        return this.projects;
    }

    @Override
    public void visit0(PlanNodeVisitor visitor) {
        visitor.onProjectNode(this);
    }

    @Override
    public PlanNodeSchema getSchema0() {
        ArrayList<QueryDataType> types = new ArrayList<QueryDataType>(this.projects.size());
        for (Expression project : this.projects) {
            types.add(project.getType());
        }
        return new PlanNodeSchema(types);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public void writeData1(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeList(this.projects, out);
    }

    @Override
    public void readData1(ObjectDataInput in) throws IOException {
        this.projects = SerializationUtil.readList(in);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.projects, this.upstream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectPlanNode that = (ProjectPlanNode)o;
        return this.id == that.id && this.projects.equals(that.projects) && this.upstream.equals(that.upstream);
    }
}

