/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.spring.SpringResource;
import liquibase.resource.AbstractResourceAccessor;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.StringUtils;

public class SpringResourceAccessor
extends AbstractResourceAccessor {
    private final ResourceLoader resourceLoader;
    private final DefaultResourceLoader fallbackResourceLoader;

    public SpringResourceAccessor(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.fallbackResourceLoader = resourceLoader == null ? new DefaultResourceLoader(Thread.currentThread().getContextClassLoader()) : new DefaultResourceLoader(resourceLoader.getClassLoader());
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<liquibase.resource.Resource> getAll(String path) throws IOException {
        path = this.finalizeSearchPath(path);
        Resource[] springResources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources(path);
        ArrayList<liquibase.resource.Resource> returnList = new ArrayList<liquibase.resource.Resource>();
        for (Resource resource : springResources) {
            if (!resource.exists()) continue;
            returnList.add(new SpringResource(path, resource.getURI(), resource));
        }
        if (returnList.isEmpty()) {
            return null;
        }
        return returnList;
    }

    @Override
    public List<liquibase.resource.Resource> search(String searchPath, boolean recursive) throws IOException {
        searchPath = recursive ? searchPath + "/**" : searchPath + "/*";
        searchPath = this.finalizeSearchPath(searchPath);
        Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources(searchPath);
        ArrayList<liquibase.resource.Resource> returnList = new ArrayList<liquibase.resource.Resource>();
        for (Resource resource : resources) {
            boolean isFile = this.resourceIsFile(resource);
            if (!isFile) continue;
            returnList.add(new SpringResource(this.getResourcePath(resource), resource.getURI(), resource));
        }
        return returnList;
    }

    @Override
    public List<String> describeLocations() {
        return Collections.singletonList("Spring classpath");
    }

    protected String getResourcePath(Resource resource) {
        if (resource instanceof ContextResource) {
            return ((ContextResource)resource).getPathWithinContext();
        }
        if (resource instanceof ClassPathResource) {
            return ((ClassPathResource)resource).getPath();
        }
        try {
            String url = resource.getURL().toExternalForm();
            if (url.contains("!")) {
                return url.replaceFirst(".*!", "");
            }
            while (!this.getResource("classpath:" + url).exists()) {
                String newUrl = url.replaceFirst("^/?.*?/", "");
                if (newUrl.equals(url)) {
                    throw new UnexpectedLiquibaseException("Could determine path for " + resource.getURL().toExternalForm());
                }
                url = newUrl;
            }
            return url;
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException("Cannot determine resource path for " + resource.getDescription());
        }
    }

    protected String getCompletePath(String relativeTo, String path) throws IOException {
        String searchPath;
        path = path.replace("\\", "/");
        if (relativeTo == null) {
            searchPath = path;
        } else {
            Resource rootResource = this.getResource(relativeTo = relativeTo.replace("\\", "/"));
            boolean relativeIsFile = this.resourceIsFile(rootResource);
            if (relativeIsFile) {
                String relativePath = relativeTo.replaceFirst("[^/]+$", "");
                searchPath = relativePath + path;
            } else {
                searchPath = relativeTo + "/" + path;
            }
        }
        return searchPath;
    }

    protected Resource getResource(String resourcePath) {
        Resource defaultLoaderResource = this.fallbackResourceLoader.getResource(resourcePath);
        if (defaultLoaderResource.exists()) {
            return defaultLoaderResource;
        }
        return this.resourceLoader.getResource(resourcePath);
    }

    protected boolean resourceIsFile(Resource resource) throws IOException {
        if (resource.exists() && resource.isFile()) {
            return resource.getFile().isFile();
        }
        String filename = resource.getFilename();
        return filename != null && filename.contains(".");
    }

    protected String finalizeSearchPath(String searchPath) {
        if (searchPath.matches("^classpath\\*?:.*")) {
            searchPath = searchPath.replace("classpath:", "").replace("classpath*:", "");
            searchPath = "classpath*:/" + searchPath;
        } else if (!searchPath.matches("^\\w+:.*")) {
            searchPath = "classpath*:/" + searchPath;
        }
        searchPath = searchPath.replace("\\", "/");
        searchPath = searchPath.replaceAll("//+", "/");
        searchPath = StringUtils.cleanPath((String)searchPath);
        return searchPath;
    }
}

