/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.scanner;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Sets;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.annotation.DiffIgnoreProperties;
import org.javers.core.metamodel.annotation.Entity;
import org.javers.core.metamodel.annotation.ShallowReference;
import org.javers.core.metamodel.annotation.Value;
import org.javers.core.metamodel.annotation.ValueObject;
import org.javers.core.metamodel.scanner.AnnotationNamesProvider;
import org.javers.core.metamodel.scanner.ClassAnnotationsScan;
import org.javers.core.metamodel.scanner.JaversAnnotationsNameSpace;
import org.javers.core.metamodel.scanner.TypeFromAnnotation;

class ClassAnnotationsScanner {
    private final AnnotationNamesProvider annotationNamesProvider;
    private List<Class<? extends Annotation>> JAVERS_TYPE_ANNOTATIONS = Lists.immutableListOf(DiffIgnore.class, DiffIgnoreProperties.class, Entity.class, ShallowReference.class, ValueObject.class, Value.class);

    ClassAnnotationsScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    public ClassAnnotationsScan scan(Class javaClass) {
        Validate.argumentIsNotNull(javaClass);
        Set<Annotation> annotations = Sets.asSet(javaClass.getAnnotations());
        Set<Class<? extends Annotation>> annTypes = annotations.stream().map(a -> a.annotationType()).collect(Collectors.toSet());
        Optional<String> typeName = this.annotationNamesProvider.findTypeNameAnnValue(annotations);
        Optional<Class> javersTypeAnnotation = this.JAVERS_TYPE_ANNOTATIONS.stream().filter(annTypes::contains).findFirst();
        boolean hasIgnoreDeclaredProperties = annTypes.contains(JaversAnnotationsNameSpace.IGNORE_DECLARED_PROPERTIES_ANN);
        return new ClassAnnotationsScan(this.typeFromAnnotation(annTypes), hasIgnoreDeclaredProperties, typeName);
    }

    private TypeFromAnnotation typeFromAnnotation(Set<Class<? extends Annotation>> annTypes) {
        Optional<Class> javersTypeAnnotation = this.JAVERS_TYPE_ANNOTATIONS.stream().filter(annTypes::contains).findFirst();
        if (javersTypeAnnotation.isPresent()) {
            return new TypeFromAnnotation(javersTypeAnnotation.get());
        }
        boolean hasValue = this.annotationNamesProvider.hasValueAnnAlias(annTypes);
        boolean hasValueObject = this.annotationNamesProvider.hasValueObjectAnnAlias(annTypes);
        boolean hasEntity = this.annotationNamesProvider.hasEntityAnnAlias(annTypes);
        return new TypeFromAnnotation(hasEntity, hasValueObject, hasValue);
    }
}

