/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.javers.common.collections.Lists;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedPropertiesFilter;

class ManagedClass {
    private final Class<?> baseJavaClass;
    private final Map<String, JaversProperty> propertiesByName;
    private final List<JaversProperty> managedProperties;
    private final List<JaversProperty> looksLikeId;
    private final ManagedPropertiesFilter managedPropertiesFilter;

    ManagedClass(Class baseJavaClass, List<JaversProperty> managedProperties, List<JaversProperty> looksLikeId, ManagedPropertiesFilter managedPropertiesFilter) {
        Validate.argumentsAreNotNull(baseJavaClass, managedProperties, looksLikeId, managedPropertiesFilter);
        this.baseJavaClass = baseJavaClass;
        this.looksLikeId = Lists.immutableCopyOf(looksLikeId);
        this.managedPropertiesFilter = managedPropertiesFilter;
        this.managedProperties = Lists.immutableCopyOf(managedProperties);
        this.propertiesByName = new HashMap<String, JaversProperty>();
        managedProperties.forEach(property -> this.propertiesByName.put(property.getName(), (JaversProperty)property));
    }

    static ManagedClass unknown() {
        return new ManagedClass(Object.class, Collections.emptyList(), Collections.emptyList(), ManagedPropertiesFilter.empty());
    }

    ManagedClass createShallowReference() {
        return new ManagedClass(this.baseJavaClass, Collections.emptyList(), this.getLooksLikeId(), ManagedPropertiesFilter.empty());
    }

    ManagedPropertiesFilter getManagedPropertiesFilter() {
        return this.managedPropertiesFilter;
    }

    List<JaversProperty> getManagedProperties() {
        return this.managedProperties;
    }

    List<JaversProperty> getLooksLikeId() {
        return this.looksLikeId;
    }

    Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.propertiesByName.keySet());
    }

    List<JaversProperty> getManagedProperties(Predicate<JaversProperty> query) {
        return Lists.positiveFilter(this.managedProperties, query);
    }

    JaversProperty getProperty(String withName) {
        Validate.argumentIsNotNull(withName);
        if (!this.propertiesByName.containsKey(withName)) {
            throw new JaversException(JaversExceptionCode.PROPERTY_NOT_FOUND, withName, this.baseJavaClass.getName());
        }
        return this.propertiesByName.get(withName);
    }

    List<JaversProperty> getProperties(List<String> withNames) {
        Validate.argumentIsNotNull(withNames);
        return withNames.stream().map(n -> this.getProperty((String)n)).collect(Collectors.toList());
    }

    boolean hasProperty(String propertyName) {
        return this.propertiesByName.containsKey(propertyName);
    }

    void forEachProperty(Consumer<JaversProperty> consumer) {
        this.managedProperties.forEach(p -> consumer.accept((JaversProperty)p));
    }

    Class<?> getBaseJavaClass() {
        return this.baseJavaClass;
    }
}

