/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.schema.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.model.IndexBuilder;
import org.polyjdbc.core.schema.model.RelationBuilder;
import org.polyjdbc.core.schema.model.SchemaEntity;
import org.polyjdbc.core.schema.model.Sequence;
import org.polyjdbc.core.schema.model.SequenceBuilder;

public final class Schema {
    private final Dialect dialect;
    private final List<SchemaEntity> entities = new ArrayList<SchemaEntity>();
    private final List<Sequence> sequences = new ArrayList<Sequence>();
    private String schemaName;

    public Schema(Dialect dialect) {
        this(dialect, null);
    }

    public Schema(Dialect dialect, String schemaName) {
        this.dialect = dialect;
        this.schemaName = schemaName;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public List<SchemaEntity> getEntities() {
        return Collections.unmodifiableList(this.entities);
    }

    public List<Sequence> getSequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    void add(SchemaEntity entity) {
        this.entities.add(entity);
    }

    void add(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public RelationBuilder addRelation(String name) {
        return RelationBuilder.relation(this, name, this.getSchemaName());
    }

    public IndexBuilder addIndex(String name) {
        return IndexBuilder.index(this, name, this.getSchemaName());
    }

    public SequenceBuilder addSequence(String name) {
        return SequenceBuilder.sequence(this, name, this.getSchemaName());
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

