/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.schema.model;

import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.model.SchemaEntity;

public class Sequence
implements SchemaEntity {
    private final String name;
    private final Dialect dialect;
    private String schemaNameWithSeparator;

    public Sequence(Dialect dialect, String name) {
        this(dialect, name, "");
    }

    public Sequence(Dialect dialect, String name, String schemaName) {
        this.name = name;
        this.dialect = dialect;
        this.schemaNameWithSeparator = schemaName == null || schemaName.isEmpty() ? "" : schemaName + ".";
    }

    public String toString() {
        return this.ddl();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String ddl() {
        return this.dialect.constraints().createSequence(this.schemaNameWithSeparator + this.name);
    }

    @Override
    public String dropDDL() {
        return "DROP SEQUENCE " + this.schemaNameWithSeparator + this.name;
    }
}

