/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.gcp;

import com.hazelcast.gcp.Label;
import com.hazelcast.gcp.PortRange;
import java.util.ArrayList;
import java.util.List;

final class GcpConfig {
    private final String privateKeyPath;
    private final List<String> projects;
    private final List<String> zones;
    private final Label label;
    private final PortRange hzPort;
    private final String region;

    private GcpConfig(String privateKeyPath, List<String> projects, List<String> zones, Label label, PortRange hzPort, String region) {
        this.privateKeyPath = privateKeyPath;
        this.projects = projects;
        this.zones = zones;
        this.label = label;
        this.hzPort = hzPort;
        this.region = region;
    }

    String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    List<String> getProjects() {
        return this.projects;
    }

    List<String> getZones() {
        return this.zones;
    }

    Label getLabel() {
        return this.label;
    }

    PortRange getHzPort() {
        return this.hzPort;
    }

    String getRegion() {
        return this.region;
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String privateKeyPath;
        private List<String> projects = new ArrayList<String>();
        private List<String> zones = new ArrayList<String>();
        private Label label;
        private PortRange hzPort;
        private String region;

        Builder() {
        }

        Builder setPrivateKeyPath(String privateKeyPath) {
            this.privateKeyPath = privateKeyPath;
            return this;
        }

        Builder setProjects(List<String> projects) {
            this.projects = projects;
            return this;
        }

        Builder setZones(List<String> zones) {
            this.zones = zones;
            return this;
        }

        Builder setLabel(Label label) {
            this.label = label;
            return this;
        }

        Builder setHzPort(PortRange hzPort) {
            this.hzPort = hzPort;
            return this;
        }

        Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        GcpConfig build() {
            return new GcpConfig(this.privateKeyPath, this.projects, this.zones, this.label, this.hzPort, this.region);
        }
    }
}

