/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableAggregate;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRules;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.InvalidRelException;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalAggregate;

class EnumerableAggregateRule
extends ConverterRule {
    EnumerableAggregateRule() {
        super(LogicalAggregate.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableAggregateRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalAggregate agg = (LogicalAggregate)rel;
        RelTraitSet traitSet = rel.getCluster().traitSet().replace(EnumerableConvention.INSTANCE);
        try {
            return new EnumerableAggregate(rel.getCluster(), traitSet, EnumerableAggregateRule.convert(agg.getInput(), traitSet), agg.getGroupSet(), agg.getGroupSets(), agg.getAggCallList());
        }
        catch (InvalidRelException e) {
            EnumerableRules.LOGGER.debug(e.toString());
            return null;
        }
    }
}

