/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.avatica;

import com.hazelcast.com.fasterxml.jackson.annotation.JsonCreator;
import com.hazelcast.com.fasterxml.jackson.annotation.JsonProperty;
import com.hazelcast.com.google.protobuf.Descriptors;
import com.hazelcast.org.apache.calcite.avatica.Meta;
import com.hazelcast.org.apache.calcite.avatica.proto.Common;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;

public class ConnectionPropertiesImpl
implements Meta.ConnectionProperties {
    private static final Descriptors.FieldDescriptor CATALOG_DESCRIPTOR = Common.ConnectionProperties.getDescriptor().findFieldByNumber(5);
    private static final Descriptors.FieldDescriptor SCHEMA_DESCRIPTOR = Common.ConnectionProperties.getDescriptor().findFieldByNumber(6);
    private static final Descriptors.FieldDescriptor TRANSACTION_ISOLATION_DESCRIPTOR = Common.ConnectionProperties.getDescriptor().findFieldByNumber(4);
    private boolean isDirty = false;
    private Boolean autoCommit;
    private Boolean readOnly;
    private Integer transactionIsolation;
    private String catalog;
    private String schema;

    public ConnectionPropertiesImpl() {
    }

    public ConnectionPropertiesImpl(Connection conn) throws SQLException {
        this(conn.getAutoCommit(), conn.isReadOnly(), conn.getTransactionIsolation(), conn.getCatalog(), conn.getSchema());
    }

    @JsonCreator
    public ConnectionPropertiesImpl(@JsonProperty(value="autoCommit") Boolean autoCommit, @JsonProperty(value="readOnly") Boolean readOnly, @JsonProperty(value="transactionIsolation") Integer transactionIsolation, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schema") String schema) {
        this.autoCommit = autoCommit;
        this.readOnly = readOnly;
        this.transactionIsolation = transactionIsolation;
        this.catalog = catalog;
        this.schema = schema;
    }

    public ConnectionPropertiesImpl setDirty(boolean val) {
        this.isDirty = val;
        return this;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean isEmpty() {
        return this.autoCommit == null && this.readOnly == null && this.transactionIsolation == null && this.catalog == null && this.schema == null;
    }

    @Override
    public ConnectionPropertiesImpl merge(Meta.ConnectionProperties that) {
        if (this == that) {
            return this;
        }
        if (that.isAutoCommit() != null && !Objects.equals(this.autoCommit, that.isAutoCommit())) {
            this.autoCommit = that.isAutoCommit();
            this.isDirty = true;
        }
        if (that.isReadOnly() != null && !Objects.equals(this.readOnly, that.isReadOnly())) {
            this.readOnly = that.isReadOnly();
            this.isDirty = true;
        }
        if (that.getTransactionIsolation() != null && !Objects.equals(this.transactionIsolation, that.getTransactionIsolation())) {
            this.transactionIsolation = that.getTransactionIsolation();
            this.isDirty = true;
        }
        if (that.getCatalog() != null && !that.getCatalog().equalsIgnoreCase(this.catalog)) {
            this.catalog = that.getCatalog();
            this.isDirty = true;
        }
        if (that.getSchema() != null && !that.getSchema().equalsIgnoreCase(this.schema)) {
            this.schema = that.getSchema();
            this.isDirty = true;
        }
        return this;
    }

    @Override
    public Meta.ConnectionProperties setAutoCommit(boolean val) {
        this.autoCommit = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public Boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public Meta.ConnectionProperties setReadOnly(boolean val) {
        this.readOnly = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Meta.ConnectionProperties setTransactionIsolation(int val) {
        this.transactionIsolation = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public Integer getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public Meta.ConnectionProperties setCatalog(String val) {
        this.catalog = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public Meta.ConnectionProperties setSchema(String val) {
        this.schema = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public int hashCode() {
        return Objects.hash(this.autoCommit, this.catalog, this.isDirty, this.readOnly, this.schema, this.transactionIsolation);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ConnectionPropertiesImpl && Objects.equals(this.autoCommit, ((ConnectionPropertiesImpl)o).autoCommit) && Objects.equals(this.catalog, ((ConnectionPropertiesImpl)o).catalog) && this.isDirty == ((ConnectionPropertiesImpl)o).isDirty && Objects.equals(this.readOnly, ((ConnectionPropertiesImpl)o).readOnly) && Objects.equals(this.schema, ((ConnectionPropertiesImpl)o).schema) && Objects.equals(this.transactionIsolation, ((ConnectionPropertiesImpl)o).transactionIsolation);
    }

    @Override
    public Common.ConnectionProperties toProto() {
        Common.ConnectionProperties.Builder builder = Common.ConnectionProperties.newBuilder();
        if (null != this.autoCommit) {
            builder.setHasAutoCommit(true);
            builder.setAutoCommit(this.autoCommit);
        } else {
            builder.setHasAutoCommit(false);
        }
        if (null != this.catalog) {
            builder.setCatalog(this.catalog);
        }
        builder.setIsDirty(this.isDirty);
        if (null != this.readOnly) {
            builder.setHasReadOnly(true);
            builder.setReadOnly(this.readOnly);
        } else {
            builder.setHasReadOnly(false);
        }
        if (null != this.schema) {
            builder.setSchema(this.schema);
        }
        if (null != this.transactionIsolation) {
            builder.setTransactionIsolation(this.transactionIsolation);
        }
        return builder.build();
    }

    public static ConnectionPropertiesImpl fromProto(Common.ConnectionProperties proto) {
        String catalog = null;
        if (proto.hasField(CATALOG_DESCRIPTOR)) {
            catalog = proto.getCatalog();
        }
        String schema = null;
        if (proto.hasField(SCHEMA_DESCRIPTOR)) {
            schema = proto.getSchema();
        }
        Boolean autoCommit = null;
        if (proto.getHasAutoCommit()) {
            autoCommit = proto.getAutoCommit();
        }
        Boolean readOnly = null;
        if (proto.getHasReadOnly()) {
            readOnly = proto.getReadOnly();
        }
        Integer transactionIsolation = null;
        if (proto.hasField(TRANSACTION_ISOLATION_DESCRIPTOR)) {
            transactionIsolation = proto.getTransactionIsolation();
        }
        ConnectionPropertiesImpl impl = new ConnectionPropertiesImpl(autoCommit, readOnly, transactionIsolation, catalog, schema);
        impl.setDirty(proto.getIsDirty());
        return impl;
    }
}

