/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.operation;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.exec.root.RootResultConsumer;
import com.hazelcast.sql.impl.operation.QueryAbstractIdAwareOperation;
import com.hazelcast.sql.impl.operation.QueryExecuteOperationFragment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class QueryExecuteOperation
extends QueryAbstractIdAwareOperation {
    private Map<UUID, PartitionIdSet> partitionMap;
    private List<QueryExecuteOperationFragment> fragments;
    private Map<Integer, Integer> outboundEdgeMap;
    private Map<Integer, Integer> inboundEdgeMap;
    private Map<Integer, Long> edgeInitialMemoryMap;
    private List<Object> arguments;
    private transient RootResultConsumer rootConsumer;
    private transient int rootBatchSize;

    public QueryExecuteOperation() {
    }

    public QueryExecuteOperation(QueryId queryId, Map<UUID, PartitionIdSet> partitionMap, List<QueryExecuteOperationFragment> fragments, Map<Integer, Integer> outboundEdgeMap, Map<Integer, Integer> inboundEdgeMap, Map<Integer, Long> edgeInitialMemoryMap, List<Object> arguments) {
        super(queryId);
        assert (partitionMap != null && !partitionMap.isEmpty()) : partitionMap;
        assert (fragments != null && fragments.size() > 0) : fragments;
        assert (outboundEdgeMap != null);
        assert (inboundEdgeMap != null);
        assert (inboundEdgeMap.size() == outboundEdgeMap.size());
        assert (edgeInitialMemoryMap != null);
        assert (edgeInitialMemoryMap.size() == outboundEdgeMap.size());
        this.queryId = queryId;
        this.partitionMap = partitionMap;
        this.fragments = fragments;
        this.outboundEdgeMap = outboundEdgeMap;
        this.inboundEdgeMap = inboundEdgeMap;
        this.edgeInitialMemoryMap = edgeInitialMemoryMap;
        this.arguments = arguments;
    }

    public Map<UUID, PartitionIdSet> getPartitionMap() {
        return this.partitionMap;
    }

    public List<QueryExecuteOperationFragment> getFragments() {
        return this.fragments;
    }

    public Map<Integer, Integer> getOutboundEdgeMap() {
        return this.outboundEdgeMap;
    }

    public Map<Integer, Integer> getInboundEdgeMap() {
        return this.inboundEdgeMap;
    }

    public Map<Integer, Long> getEdgeInitialMemoryMap() {
        return this.edgeInitialMemoryMap;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public RootResultConsumer getRootConsumer() {
        return this.rootConsumer;
    }

    public int getRootBatchSize() {
        return this.rootBatchSize;
    }

    public QueryExecuteOperation setRootConsumer(RootResultConsumer rootConsumer, int rootBatchSize) {
        this.rootConsumer = rootConsumer;
        this.rootBatchSize = rootBatchSize;
        return this;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    protected void writeInternal1(ObjectDataOutput out) throws IOException {
        out.writeInt(this.partitionMap.size());
        for (Map.Entry<UUID, PartitionIdSet> entry : this.partitionMap.entrySet()) {
            UUIDSerializationUtil.writeUUID(out, entry.getKey());
            SerializationUtil.writeNullablePartitionIdSet(entry.getValue(), out);
        }
        out.writeInt(this.fragments.size());
        for (QueryExecuteOperationFragment queryExecuteOperationFragment : this.fragments) {
            out.writeObject(queryExecuteOperationFragment);
        }
        out.writeInt(this.outboundEdgeMap.size());
        for (Map.Entry entry : this.outboundEdgeMap.entrySet()) {
            out.writeInt((Integer)entry.getKey());
            out.writeInt((Integer)entry.getValue());
        }
        out.writeInt(this.inboundEdgeMap.size());
        for (Map.Entry entry : this.inboundEdgeMap.entrySet()) {
            out.writeInt((Integer)entry.getKey());
            out.writeInt((Integer)entry.getValue());
        }
        out.writeInt(this.edgeInitialMemoryMap.size());
        for (Map.Entry entry : this.edgeInitialMemoryMap.entrySet()) {
            out.writeInt((Integer)entry.getKey());
            out.writeLong((Long)entry.getValue());
        }
        if (this.arguments == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.arguments.size());
            for (Object object : this.arguments) {
                out.writeObject(object);
            }
        }
    }

    @Override
    protected void readInternal1(ObjectDataInput in) throws IOException {
        int partitionMappingCnt = in.readInt();
        this.partitionMap = new HashMap<UUID, PartitionIdSet>(partitionMappingCnt);
        for (int i = 0; i < partitionMappingCnt; ++i) {
            UUID key = UUIDSerializationUtil.readUUID(in);
            PartitionIdSet val = SerializationUtil.readNullablePartitionIdSet(in);
            this.partitionMap.put(key, val);
        }
        int fragmentCnt = in.readInt();
        this.fragments = new ArrayList<QueryExecuteOperationFragment>(fragmentCnt);
        for (int i = 0; i < fragmentCnt; ++i) {
            QueryExecuteOperationFragment fragment = (QueryExecuteOperationFragment)in.readObject();
            this.fragments.add(fragment);
        }
        int outboundEdgeMapSize = in.readInt();
        this.outboundEdgeMap = new HashMap<Integer, Integer>(outboundEdgeMapSize);
        for (int i = 0; i < outboundEdgeMapSize; ++i) {
            this.outboundEdgeMap.put(in.readInt(), in.readInt());
        }
        int inboundEdgeMapSize = in.readInt();
        this.inboundEdgeMap = new HashMap<Integer, Integer>(inboundEdgeMapSize);
        for (int i = 0; i < inboundEdgeMapSize; ++i) {
            this.inboundEdgeMap.put(in.readInt(), in.readInt());
        }
        int edgeCreditMapSize = in.readInt();
        this.edgeInitialMemoryMap = new HashMap<Integer, Long>(edgeCreditMapSize);
        for (int i = 0; i < edgeCreditMapSize; ++i) {
            this.edgeInitialMemoryMap.put(in.readInt(), in.readLong());
        }
        int argumentCnt = in.readInt();
        if (argumentCnt == 0) {
            this.arguments = Collections.emptyList();
        } else {
            this.arguments = new ArrayList<Object>(argumentCnt);
            for (int i = 0; i < argumentCnt; ++i) {
                this.arguments.add(in.readObject());
            }
        }
    }
}

