/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.plan.node.AbstractMapScanPlanNode;
import com.hazelcast.sql.impl.plan.node.PlanNodeVisitor;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class MapIndexScanPlanNode
extends AbstractMapScanPlanNode
implements IdentifiedDataSerializable {
    private String indexName;
    private int indexComponentCount;
    private IndexFilter indexFilter;
    private List<QueryDataType> converterTypes;
    private List<Boolean> ascs;

    public MapIndexScanPlanNode() {
    }

    public MapIndexScanPlanNode(int id, String mapName, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, List<QueryPath> fieldPaths, List<QueryDataType> fieldTypes, List<Integer> projects, String indexName, int indexComponentCount, IndexFilter indexFilter, List<QueryDataType> converterTypes, Expression<Boolean> remainderFilter, List<Boolean> ascs) {
        super(id, mapName, keyDescriptor, valueDescriptor, fieldPaths, fieldTypes, projects, remainderFilter);
        this.indexName = indexName;
        this.indexComponentCount = indexComponentCount;
        this.indexFilter = indexFilter;
        this.converterTypes = converterTypes;
        this.ascs = ascs;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getIndexComponentCount() {
        return this.indexComponentCount;
    }

    public IndexFilter getIndexFilter() {
        return this.indexFilter;
    }

    public List<QueryDataType> getConverterTypes() {
        return this.converterTypes;
    }

    public List<Boolean> getAscs() {
        return this.ascs;
    }

    @Override
    public void visit(PlanNodeVisitor visitor) {
        visitor.onMapIndexScanNode(this);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 52;
    }

    @Override
    protected void writeData0(ObjectDataOutput out) throws IOException {
        super.writeData0(out);
        out.writeString(this.indexName);
        out.writeInt(this.indexComponentCount);
        out.writeObject(this.indexFilter);
        SerializationUtil.writeList(this.converterTypes, out);
        SerializationUtil.writeList(this.ascs, out);
    }

    @Override
    protected void readData0(ObjectDataInput in) throws IOException {
        super.readData0(in);
        this.indexName = in.readString();
        this.indexComponentCount = in.readInt();
        this.indexFilter = (IndexFilter)in.readObject();
        this.converterTypes = SerializationUtil.readList(in);
        this.ascs = SerializationUtil.readList(in);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapIndexScanPlanNode that = (MapIndexScanPlanNode)o;
        return this.indexComponentCount == that.indexComponentCount && this.indexName.equals(that.indexName) && Objects.equals(this.indexFilter, that.indexFilter) && Objects.equals(this.converterTypes, that.converterTypes) && Objects.equals(this.ascs, that.ascs);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.indexName.hashCode();
        result = 31 * result + this.indexComponentCount;
        result = 31 * result + (this.indexFilter != null ? this.indexFilter.hashCode() : 0);
        result = 31 * result + (this.converterTypes != null ? this.converterTypes.hashCode() : 0);
        result = 31 * result + this.ascs.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", mapName=" + this.mapName + ", fieldPaths=" + this.fieldPaths + ", projects=" + this.projects + ", indexName=" + this.indexName + ", indexFilter=" + this.indexFilter + ", remainderFilter=" + this.filter + ", ascs=" + this.ascs + '}';
    }
}

