/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.dialect;

import org.polyjdbc.core.dialect.DialectConstraints;
import org.polyjdbc.core.util.StringUtils;
import org.polyjdbc.core.util.TypeUtil;

public class DefaultDialectConstraints
implements DialectConstraints {
    @Override
    public String createSequence(String name) {
        return "CREATE SEQUENCE " + name;
    }

    @Override
    public String primaryKey(String name, String[] targetAttributes) {
        return "CONSTRAINT " + name + " PRIMARY KEY(" + StringUtils.concatenate(", ", (Object[])targetAttributes) + ")";
    }

    @Override
    public String foreignKey(String name, String targetAttribute, String targetRelation, String targetRelationAttribute) {
        return "CONSTRAINT " + name + " FOREIGN KEY(" + targetAttribute + ") REFERENCES " + targetRelation + "(" + targetRelationAttribute + ")";
    }

    @Override
    public String dropIndex(String name, String targetRelationName) {
        return "DROP INDEX " + name;
    }

    @Override
    public String attributeModifiers(boolean unique, boolean notNull, Object defaultValue) {
        StringBuilder builder = new StringBuilder();
        if (unique) {
            builder.append("UNIQUE ");
        }
        if (notNull) {
            builder.append("NOT NULL ");
        }
        if (defaultValue != null) {
            this.appendAttrDefaultValue(builder, defaultValue);
        }
        return builder.toString();
    }

    void appendAttrDefaultValue(StringBuilder builder, Object defaultValue) {
        boolean primitive = TypeUtil.isNonQuotablePrimitive(defaultValue);
        builder.append("DEFAULT ");
        if (!primitive) {
            builder.append("'");
        }
        builder.append(this.encodeDefaultValue(defaultValue));
        if (!primitive) {
            builder.append("'");
        }
        builder.append(" ");
    }

    String encodeDefaultValue(Object defaultValue) {
        return defaultValue.toString();
    }

    String encodeBooleanToBit(Boolean bool) {
        if (bool.booleanValue()) {
            return "1";
        }
        return "0";
    }
}

