/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.schema.model;

import java.util.Arrays;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.model.SchemaEntity;
import org.polyjdbc.core.util.StringUtils;

public class Index
implements SchemaEntity {
    private static final int DDL_LENGTH = 50;
    private Dialect dialect;
    private String name;
    private String targetRelation;
    private String[] targetAttributes;
    private String schemaNameWithSeparator;

    Index(Dialect dialect, String name) {
        this(dialect, name, "");
    }

    Index(Dialect dialect, String name, String schemaName) {
        this.dialect = dialect;
        this.name = name;
        this.schemaNameWithSeparator = schemaName == null || schemaName.isEmpty() ? "" : schemaName + ".";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.ddl();
    }

    @Override
    public String ddl() {
        StringBuilder builder = new StringBuilder(50);
        builder.append("CREATE INDEX ").append(this.name).append(" ON ").append(this.schemaNameWithSeparator).append(this.targetRelation).append("(").append(StringUtils.concatenate(",", (Object[])this.targetAttributes)).append(")");
        return builder.toString();
    }

    @Override
    public String dropDDL() {
        return this.dialect.constraints().dropIndex(this.name, this.schemaNameWithSeparator + this.targetRelation);
    }

    public String getTargetRelation() {
        return this.targetRelation;
    }

    void withTargetRelation(String targetRelation) {
        this.targetRelation = targetRelation;
    }

    public String[] getTargetAttributes() {
        return Arrays.copyOf(this.targetAttributes, this.targetAttributes.length);
    }

    void withTargetAttributes(String[] targetAttributes) {
        this.targetAttributes = Arrays.copyOf(targetAttributes, targetAttributes.length);
    }
}

