/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.schema.model;

import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.model.Attribute;
import org.polyjdbc.core.schema.model.BooleanAttributeBuilder;
import org.polyjdbc.core.schema.model.CharAttributeBuilder;
import org.polyjdbc.core.schema.model.Constraint;
import org.polyjdbc.core.schema.model.DateAttributeBuilder;
import org.polyjdbc.core.schema.model.FloatAttribute;
import org.polyjdbc.core.schema.model.ForeignKeyConstraintBuilder;
import org.polyjdbc.core.schema.model.Heading;
import org.polyjdbc.core.schema.model.IntegerAttributeBuilder;
import org.polyjdbc.core.schema.model.LongAttributeBuilder;
import org.polyjdbc.core.schema.model.NumberAttribute;
import org.polyjdbc.core.schema.model.PrimaryKeyConstraintBuilder;
import org.polyjdbc.core.schema.model.Relation;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.schema.model.StringAttributeBuilder;
import org.polyjdbc.core.schema.model.TextAttributeBuilder;
import org.polyjdbc.core.schema.model.TimestampAttributeBuilder;

public final class RelationBuilder {
    private Relation relation;
    private Schema schema;
    private Heading heading;
    private Dialect dialect;

    private RelationBuilder(Dialect dialect, String name) {
        this.dialect = dialect;
        this.relation = new Relation(dialect, name);
        this.heading = new Heading(dialect);
    }

    private RelationBuilder(Dialect dialect, String name, String schemaName) {
        this.dialect = dialect;
        this.relation = new Relation(dialect, name, schemaName);
        this.heading = new Heading(dialect);
    }

    private RelationBuilder(Schema schema, String name) {
        this(schema.getDialect(), name);
        this.schema = schema;
    }

    private RelationBuilder(Schema schema, String name, String schemaName) {
        this(schema.getDialect(), name, schemaName);
        this.schema = schema;
    }

    public static RelationBuilder relation(Dialect dialect, String name) {
        return new RelationBuilder(dialect, name);
    }

    public static RelationBuilder relation(Schema schema, String name) {
        return new RelationBuilder(schema, name);
    }

    public static RelationBuilder relation(Dialect dialect, String name, String schemaName) {
        return new RelationBuilder(dialect, name, schemaName);
    }

    public static RelationBuilder relation(Schema schema, String name, String schemaName) {
        return new RelationBuilder(schema, name, schemaName);
    }

    public Relation build() {
        this.relation.withHeading(this.heading);
        if (this.schema != null) {
            this.schema.add(this.relation);
        }
        return this.relation;
    }

    RelationBuilder with(Attribute attribute) {
        this.heading.addAttribute(attribute);
        return this;
    }

    RelationBuilder with(Constraint constraint) {
        this.relation.addConstraint(constraint);
        return this;
    }

    public RelationBuilder withAttribute() {
        return this;
    }

    public LongAttributeBuilder longAttr(String name) {
        return LongAttributeBuilder.longAttr(this.dialect, name, this);
    }

    public IntegerAttributeBuilder integer(String name) {
        return IntegerAttributeBuilder.integer(this.dialect, name, this);
    }

    public FloatAttribute.FloatAttributeBuilder floatAttr(String name) {
        return FloatAttribute.FloatAttributeBuilder.floatAttr(this.dialect, name, this);
    }

    public NumberAttribute.NumberAttributeBuilder number(String name) {
        return NumberAttribute.NumberAttributeBuilder.number(this.dialect, name, this);
    }

    public StringAttributeBuilder string(String name) {
        return StringAttributeBuilder.string(this.dialect, name, this);
    }

    public TextAttributeBuilder text(String name) {
        return TextAttributeBuilder.text(this.dialect, name, this);
    }

    public CharAttributeBuilder character(String name) {
        return CharAttributeBuilder.character(this.dialect, name, this);
    }

    public BooleanAttributeBuilder booleanAttr(String name) {
        return BooleanAttributeBuilder.booleanAttr(this.dialect, name, this);
    }

    public DateAttributeBuilder date(String name) {
        return DateAttributeBuilder.date(this.dialect, name, this);
    }

    public TimestampAttributeBuilder timestamp(String name) {
        return TimestampAttributeBuilder.timestamp(this.dialect, name, this);
    }

    public RelationBuilder constrainedBy() {
        return this;
    }

    public PrimaryKeyConstraintBuilder primaryKey(String name) {
        return PrimaryKeyConstraintBuilder.primaryKey(this.dialect, name, this);
    }

    public ForeignKeyConstraintBuilder foreignKey(String name) {
        return ForeignKeyConstraintBuilder.foreignKey(this.dialect, name, this);
    }

    Attribute getAttribute(String name) {
        for (Attribute a : this.heading.getAttributes()) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }
}

