/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.transaction;

import java.sql.SQLException;
import org.polyjdbc.core.exception.PolyJdbcException;
import org.polyjdbc.core.transaction.ConnectionProvider;
import org.polyjdbc.core.transaction.ExternalTransactionState;
import org.polyjdbc.core.transaction.Transaction;
import org.polyjdbc.core.transaction.TransactionManager;

public class ExternalTransactionManager
implements TransactionManager {
    private final ConnectionProvider transactionProvider;

    public ExternalTransactionManager(ConnectionProvider transactionProvider) {
        this.transactionProvider = transactionProvider;
    }

    @Override
    public Transaction openTransaction() {
        try {
            return new Transaction(this.transactionProvider.getConnection(), new ExternalTransactionState());
        }
        catch (SQLException e) {
            throw new PolyJdbcException("OPEN_CONNECTION_ERROR", "Failed to obtain connection from connection provider.", e);
        }
    }

    @Override
    public Transaction openTransaction(boolean autoCommit) {
        return this.openTransaction();
    }
}

