/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.json.AtomicTypeAdapter;
import org.javers.core.json.JsonAdvancedTypeAdapter;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.util.UtilTypeCoreAdapters;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.java8support.Java8TypeAdapters;
import org.javers.java8support.OptionalTypeAdapter;

public class JsonConverterBuilder {
    private static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private boolean typeSafeValues = false;
    private boolean prettyPrint;
    private final GsonBuilder gsonBuilder = new GsonBuilder();

    public JsonConverterBuilder() {
        this.gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new SkipFieldExclusionStrategy()});
        this.gsonBuilder.setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE);
        this.registerBuiltInAdapters(Java8TypeAdapters.adapters());
        this.registerBuiltInAdapters(UtilTypeCoreAdapters.adapters());
        this.registerJsonAdvancedTypeAdapter(new OptionalTypeAdapter());
    }

    public JsonConverterBuilder typeSafeValues(boolean typeSafeValues) {
        this.typeSafeValues = typeSafeValues;
        return this;
    }

    public JsonConverterBuilder prettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public JsonConverterBuilder registerNativeTypeAdapter(Type targetType, TypeAdapter nativeAdapter) {
        Validate.argumentsAreNotNull(targetType, nativeAdapter);
        this.gsonBuilder.registerTypeAdapter(targetType, (Object)nativeAdapter);
        return this;
    }

    public JsonConverterBuilder registerNativeGsonSerializer(Type targetType, JsonSerializer<?> jsonSerializer) {
        Validate.argumentsAreNotNull(targetType, jsonSerializer);
        this.gsonBuilder.registerTypeAdapter(targetType, jsonSerializer);
        return this;
    }

    public JsonConverterBuilder registerNativeGsonHierarchySerializer(Class targetType, JsonSerializer<?> jsonSerializer) {
        Validate.argumentsAreNotNull(targetType, jsonSerializer);
        this.gsonBuilder.registerTypeHierarchyAdapter(targetType, jsonSerializer);
        return this;
    }

    public JsonConverterBuilder registerNativeGsonHierarchyDeserializer(Class targetType, JsonDeserializer<?> jsonDeserializer) {
        Validate.argumentsAreNotNull(targetType, jsonDeserializer);
        this.gsonBuilder.registerTypeHierarchyAdapter(targetType, jsonDeserializer);
        return this;
    }

    public JsonConverterBuilder registerNativeGsonDeserializer(Type targetType, JsonDeserializer<?> jsonDeserializer) {
        Validate.argumentsAreNotNull(targetType, jsonDeserializer);
        this.gsonBuilder.registerTypeAdapter(targetType, jsonDeserializer);
        return this;
    }

    public JsonConverterBuilder registerJsonTypeAdapters(Collection<JsonTypeAdapter> adapters) {
        Validate.argumentIsNotNull(adapters);
        for (JsonTypeAdapter adapter : adapters) {
            this.registerJsonTypeAdapter(adapter);
        }
        return this;
    }

    public JsonConverterBuilder registerJsonTypeAdapter(JsonTypeAdapter adapter) {
        Validate.argumentIsNotNull(adapter);
        adapter.getValueTypes().forEach(c -> this.registerJsonTypeAdapterForType((Class)c, adapter));
        return this;
    }

    public JsonConverterBuilder registerJsonAdvancedTypeAdapter(JsonAdvancedTypeAdapter adapter) {
        Validate.argumentIsNotNull(adapter);
        JsonSerializer jsonSerializer = (value, type, jsonSerializationContext) -> adapter.toJson(value, type, jsonSerializationContext);
        JsonDeserializer jsonDeserializer = (jsonElement, type, jsonDeserializationContext) -> adapter.fromJson(jsonElement, type, jsonDeserializationContext);
        this.registerNativeGsonHierarchySerializer(adapter.getTypeSuperclass(), jsonSerializer);
        this.registerNativeGsonHierarchyDeserializer(adapter.getTypeSuperclass(), jsonDeserializer);
        return this;
    }

    public JsonConverter build() {
        this.registerBuiltInAdapter(new AtomicTypeAdapter(this.typeSafeValues));
        if (this.prettyPrint) {
            this.gsonBuilder.setPrettyPrinting();
        }
        this.gsonBuilder.enableComplexMapKeySerialization();
        this.gsonBuilder.serializeNulls().setDateFormat(ISO_DATE_TIME_FORMAT);
        return new JsonConverter(this.gsonBuilder.create());
    }

    private void registerJsonTypeAdapterForType(Class targetType, JsonTypeAdapter adapter) {
        JsonSerializer jsonSerializer = (value, type, jsonSerializationContext) -> adapter.toJson(value, jsonSerializationContext);
        JsonDeserializer jsonDeserializer = (jsonElement, type, jsonDeserializationContext) -> adapter.fromJson(jsonElement, jsonDeserializationContext);
        this.registerNativeGsonSerializer(targetType, jsonSerializer);
        this.registerNativeGsonDeserializer(targetType, jsonDeserializer);
    }

    private void registerBuiltInAdapters(List<JsonTypeAdapter> adapters) {
        adapters.forEach(this::registerBuiltInAdapter);
    }

    private void registerBuiltInAdapter(JsonTypeAdapter adapter) {
        adapter.getValueTypes().forEach(c -> this.registerJsonTypeAdapterForType((Class)c, adapter));
    }

    private static class SkipFieldExclusionStrategy
    implements ExclusionStrategy {
        private SkipFieldExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz.getAnnotation(DiffIgnore.class) != null;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return field.getAnnotation(DiffIgnore.class) != null;
        }
    }
}

