/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.Optional;
import java.util.function.Supplier;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.core.graph.ObjectAccessProxy;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdPathParser;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.object.ValueObjectIdWithHash;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.UnboundedValueObjectIdDTO;
import org.javers.repository.jql.ValueObjectIdDTO;

public class GlobalIdFactory {
    private final TypeMapper typeMapper;
    private ObjectAccessHook objectAccessHook;
    private final GlobalIdPathParser pathParser;

    public GlobalIdFactory(TypeMapper typeMapper, ObjectAccessHook objectAccessHook) {
        this.typeMapper = typeMapper;
        this.objectAccessHook = objectAccessHook;
        this.pathParser = new GlobalIdPathParser();
    }

    public GlobalId createId(Object targetCdo) {
        return this.createId(targetCdo, null);
    }

    public GlobalId createId(Object targetCdo, OwnerContext ownerContext) {
        Validate.argumentsAreNotNull(targetCdo);
        Optional<ObjectAccessProxy<Object>> cdoProxy = this.objectAccessHook.createAccessor(targetCdo);
        Class<?> targetClass = cdoProxy.map(p -> p.getTargetClass()).orElse(targetCdo.getClass());
        ManagedType targetManagedType = this.typeMapper.getJaversManagedType(targetClass);
        if (targetManagedType instanceof EntityType) {
            if (cdoProxy.isPresent() && cdoProxy.get().getLocalId().isPresent()) {
                return this.createInstanceId(cdoProxy.get().getLocalId().get(), targetClass);
            }
            return ((EntityType)targetManagedType).createIdFromInstance(targetCdo);
        }
        if (targetManagedType instanceof ValueObjectType && !this.hasOwner(ownerContext)) {
            return new UnboundedValueObjectId(targetManagedType.getName());
        }
        if (targetManagedType instanceof ValueObjectType && this.hasOwner(ownerContext)) {
            Supplier<String> parentFragment = this.createParentFragment(ownerContext.getOwnerId());
            String localPath = ownerContext.getPath();
            if (ownerContext.requiresObjectHasher() || ValueObjectIdWithHash.containsHashPlaceholder(parentFragment.get())) {
                return new ValueObjectIdWithHash.ValueObjectIdWithPlaceholder(targetManagedType.getName(), this.getRootOwnerId(ownerContext), parentFragment, localPath, ownerContext.requiresObjectHasher());
            }
            return new ValueObjectId(targetManagedType.getName(), this.getRootOwnerId(ownerContext), parentFragment.get() + localPath);
        }
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
    }

    private Supplier<String> createParentFragment(GlobalId parentId) {
        if (parentId instanceof ValueObjectId) {
            return () -> ((ValueObjectId)parentId).getFragment() + "/";
        }
        return () -> "";
    }

    private GlobalId getRootOwnerId(OwnerContext ownerContext) {
        if (ownerContext.getOwnerId() instanceof ValueObjectId) {
            return ((ValueObjectId)ownerContext.getOwnerId()).getOwnerId();
        }
        return ownerContext.getOwnerId();
    }

    public UnboundedValueObjectId createUnboundedValueObjectId(Class valueObjectClass) {
        ValueObjectType valueObject = this.typeMapper.getJaversManagedType(valueObjectClass, ValueObjectType.class);
        return new UnboundedValueObjectId(valueObject.getName());
    }

    @Deprecated
    public ValueObjectId createValueObjectIdFromPath(GlobalId owner, String fragment) {
        ManagedType ownerType = this.typeMapper.getJaversManagedType(owner);
        ValueObjectType valueObjectType = this.pathParser.parseChildValueObject(ownerType, fragment);
        return new ValueObjectId(valueObjectType.getName(), owner, fragment);
    }

    public InstanceId createIdFromInstance(Object instance) {
        EntityType entityType = this.typeMapper.getJaversManagedType(instance.getClass(), EntityType.class);
        return entityType.createIdFromInstance(instance);
    }

    public InstanceId createInstanceId(Object localId, Class entityClass) {
        EntityType entity = this.typeMapper.getJaversManagedType(entityClass, EntityType.class);
        return entity.createIdFromInstanceId(localId);
    }

    public InstanceId createInstanceId(Object localId, String typeName) {
        Optional<EntityType> entity = this.typeMapper.getJaversManagedTypeMaybe(typeName, EntityType.class);
        return entity.map(e -> e.createIdFromInstanceId(localId)).orElseGet(() -> new InstanceId(typeName, localId, ToStringBuilder.smartToString(localId)));
    }

    public GlobalId createFromDto(GlobalIdDTO globalIdDTO) {
        if (globalIdDTO instanceof InstanceIdDTO) {
            InstanceIdDTO idDTO = (InstanceIdDTO)globalIdDTO;
            return this.createInstanceId(idDTO.getCdoId(), idDTO.getEntity());
        }
        if (globalIdDTO instanceof UnboundedValueObjectIdDTO) {
            UnboundedValueObjectIdDTO idDTO = (UnboundedValueObjectIdDTO)globalIdDTO;
            return this.createUnboundedValueObjectId(idDTO.getVoClass());
        }
        if (globalIdDTO instanceof ValueObjectIdDTO) {
            ValueObjectIdDTO idDTO = (ValueObjectIdDTO)globalIdDTO;
            GlobalId ownerId = this.createFromDto(idDTO.getOwnerIdDTO());
            return this.createValueObjectIdFromPath(ownerId, idDTO.getPath());
        }
        throw new RuntimeException("type " + globalIdDTO.getClass() + " is not implemented");
    }

    private boolean hasOwner(OwnerContext context) {
        return context != null && context.getOwnerId() != null;
    }
}

