/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.migration;

import com.google.common.base.Strings;
import java.sql.SQLException;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import org.qubership.atp.environments.db.migration.LiquibaseFactory;
import org.qubership.atp.environments.db.migration.classloader.ParentLastClassloader;
import org.qubership.atp.environments.db.migration.configuration.DbConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ComponentScan(basePackages={"org.qubership.atp.environments"})
@Import(value={DbConfiguration.class, WebMvcAutoConfiguration.class, DispatcherServletAutoConfiguration.class, ServletWebServerFactoryAutoConfiguration.class})
public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws SQLException, LiquibaseException {
        ConfigurableApplicationContext configurableApplicationContext = SpringApplication.run(Main.class, (String[])args);
        String sourcePath = System.getProperty("lb.libs.path", "env-scripts/src/main/scripts");
        String jdbcType = System.getProperty("jdbc_type");
        if (Strings.isNullOrEmpty((String)jdbcType)) {
            throw new IllegalStateException("You haven't specified system property 'jdbc_type'");
        }
        ParentLastClassloader customClassLoader = new ParentLastClassloader(sourcePath, jdbcType);
        try {
            LiquibaseFactory lbFactory = (LiquibaseFactory)configurableApplicationContext.getBean(LiquibaseFactory.class);
            Liquibase lb = lbFactory.create("install.xml");
            if (Boolean.getBoolean("drop.database.for.tests")) {
                LOGGER.info("drop database because of flag (drop.database.for.tests)");
                lb.dropAll();
            }
            lb.update(new Contexts(), new LabelExpression());
            lb = lbFactory.create("update.xml", new ClassLoaderResourceAccessor((ClassLoader)customClassLoader));
            lb.update(new Contexts(), new LabelExpression());
            configurableApplicationContext.close();
        }
        catch (Throwable e) {
            LOGGER.error("Uncaught exception", e);
            throw e;
        }
    }
}

