/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.migration.classloader;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentLastClassloader
extends URLClassLoader {
    private static final String JAR = ".jar";
    private static final Logger LOGGER = LoggerFactory.getLogger(ParentLastClassloader.class);
    private static final String Q_CLASSES_JAR_EXPRESSION = "env-q-classes-generation.+\\.jar";
    private final String sourcePath;
    private URLClassLoader urlClassLoader;
    private String jdbcType;

    public ParentLastClassloader(String sourcePath, String jdbcType) {
        super(new URL[0], ParentLastClassloader.getSystemClassLoader());
        this.jdbcType = jdbcType;
        if (Strings.isNullOrEmpty((String)jdbcType)) {
            throw new IllegalStateException("Parameter 'jdbc_type' can't be null or empty.Value of jdbc_type depends of suffix in jar name, which contains generated q-classes.env-q-classes-generation-pg.jar - there is jdbc_type is 'pg'");
        }
        this.sourcePath = sourcePath;
        try (Stream<Path> walk = Files.walk(Paths.get(sourcePath, new String[0]), new FileVisitOption[0]);){
            walk.filter(path -> !this.isJarFile((Path)path)).forEach(path -> {
                try {
                    this.addURL(path.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Unable convert file to url", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Unable to add resource files to classpath", (Throwable)e);
        }
    }

    private boolean isJarFile(Path path) {
        return path.toString().toLowerCase(Locale.ENGLISH).endsWith(JAR);
    }

    @Override
    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = null;
        try {
            resources = this.findResources(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resources != null && !resources.hasMoreElements()) {
            return this.loadFromSuper(name);
        }
        return resources;
    }

    private Enumeration<URL> loadFromSuper(String name) throws IOException {
        LOGGER.warn("Resource not found in self class loader. Resource: " + name);
        return super.getResources(name);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> loadedClass;
        if (className.matches("^v\\d+.+")) {
            this.refreshClassLoader(className);
        }
        if ((loadedClass = this.urlClassLoader.loadClass(className)) == null) {
            super.loadClass(className);
        }
        return loadedClass;
    }

    protected void refreshClassLoader(String className) {
        String jarPath = className.replaceAll("\\.", "/").replaceFirst("\\w+$", "");
        try {
            Path dir = Paths.get(this.sourcePath, jarPath);
            List<Path> jarList = Files.list(dir).filter(this::isJarFile).collect(Collectors.toList());
            if (this.urlClassLoader != null) {
                this.urlClassLoader.close();
            }
            this.urlClassLoader = this.getUrlClassLoader(jarList);
        }
        catch (IOException e) {
            throw new IllegalStateException("Jar file is not found by path:" + jarPath, e);
        }
    }

    private FindFirstClassLoader getUrlClassLoader(List<Path> jarList) {
        LinkedList urls = new LinkedList();
        jarList.forEach(path -> {
            try {
                String name = path.toFile().getName().toLowerCase(Locale.ENGLISH);
                if (name.matches(Q_CLASSES_JAR_EXPRESSION)) {
                    this.loadGeneratedQClasses(urls, name, (Path)path);
                } else {
                    urls.add(this.getUrl((Path)path));
                }
            }
            catch (IOException e) {
                LOGGER.error("Can't convert path to URL. File path:" + path, (Throwable)e);
            }
        });
        return new FindFirstClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
    }

    private void loadGeneratedQClasses(List<URL> urls, String name, Path path) throws IOException {
        if (name.endsWith(this.jdbcType + JAR)) {
            urls.add(this.getUrl(path));
        }
    }

    private URL getUrl(Path jarFile) throws IOException {
        return new URL("jar:file:" + jarFile.toString() + "!/");
    }

    private static class FindFirstClassLoader
    extends URLClassLoader {
        private FindFirstClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.findClass(name);
            }
            catch (Exception e) {
                return super.loadClass(name);
            }
        }
    }
}

