/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.query;

import org.polyjdbc.core.exception.TransactionInterruptedException;
import org.polyjdbc.core.query.QueryRunner;
import org.polyjdbc.core.query.QueryRunnerFactory;
import org.polyjdbc.core.query.TransactionWrapper;
import org.polyjdbc.core.util.TheCloser;

public class TransactionRunner {
    private final QueryRunnerFactory queryRunnerFactory;

    public TransactionRunner(QueryRunnerFactory queryRunnerFactory) {
        this.queryRunnerFactory = queryRunnerFactory;
    }

    public <T> T run(TransactionWrapper<T> operation) {
        T t;
        QueryRunner runner = null;
        try {
            runner = this.queryRunnerFactory.create();
            T result = operation.perform(runner);
            runner.commit();
            t = result;
        }
        catch (Throwable throwable) {
            try {
                TheCloser.rollback(runner);
                throw new TransactionInterruptedException(throwable);
            }
            catch (Throwable throwable2) {
                TheCloser.close(runner);
                throw throwable2;
            }
        }
        TheCloser.close(runner);
        return t;
    }
}

