/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.schema.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.model.Constraint;
import org.polyjdbc.core.schema.model.Heading;
import org.polyjdbc.core.schema.model.SchemaEntity;
import org.polyjdbc.core.util.StringUtils;

public class Relation
implements SchemaEntity {
    private static final int TO_STRING_LENGTH_BASE = 30;
    private String name;
    private Dialect dialect;
    private Heading heading;
    private String schemaNameWithSeparator;
    private Collection<Constraint> constraints = new LinkedList<Constraint>();

    Relation(Dialect dialect, String name) {
        this(dialect, name, "");
    }

    Relation(Dialect dialect, String name, String schemaName) {
        this.dialect = dialect;
        this.name = name;
        this.schemaNameWithSeparator = schemaName == null || schemaName.isEmpty() ? "" : schemaName + ".";
    }

    public String toString() {
        return this.ddl();
    }

    @Override
    public String ddl() {
        String headingDDL = this.heading.toString();
        String constraintsDDL = StringUtils.concatenate(",\n", this.constraints.toArray());
        StringBuilder builder = new StringBuilder(30 + headingDDL.length() + constraintsDDL.length());
        builder.append("CREATE TABLE ").append(this.schemaNameWithSeparator + this.name).append(" (\n").append(headingDDL);
        if (constraintsDDL.length() > 0) {
            builder.append(",\n");
        }
        builder.append(constraintsDDL).append("\n) ").append(this.dialect.createRelationDefaultOptions());
        return builder.toString();
    }

    @Override
    public String dropDDL() {
        return "DROP TABLE " + this.schemaNameWithSeparator + this.name;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Heading getHeading() {
        return this.heading;
    }

    void withHeading(Heading heading) {
        this.heading = heading;
    }

    public Collection<Constraint> getConstraints() {
        return Collections.unmodifiableCollection(this.constraints);
    }

    void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }
}

