/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.polyjdbc.core.exception.PolyJdbcException;
import org.polyjdbc.core.transaction.ManagedTransactionState;
import org.polyjdbc.core.transaction.Transaction;
import org.polyjdbc.core.transaction.TransactionManager;

public class DataSourceTransactionManager
implements TransactionManager {
    private DataSource dataSource;

    public DataSourceTransactionManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Transaction openTransaction() {
        return this.openTransaction(false);
    }

    @Override
    public Transaction openTransaction(boolean autoCommit) {
        try {
            Connection connection = this.dataSource.getConnection();
            connection.setAutoCommit(autoCommit);
            return new Transaction(connection, new ManagedTransactionState(connection));
        }
        catch (SQLException e) {
            throw new PolyJdbcException("OPEN_CONNECTION_ERROR", "Failed to obtain connection from datasource.", e);
        }
    }
}

