/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.model.utils.enums;

import java.io.Serializable;
import java.util.Arrays;
import java.util.UUID;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.model.utils.HasListValueId;

public enum TypeGettingVersion implements HasListValueId,
Serializable
{
    BY_HTTP_ENDPOINT(Constants.Environment.System.Connection.HTTP),
    BY_HTTP_ENDPOINT_BASIC_AUTH(Constants.Environment.System.Connection.HTTP),
    BY_SHELL_SCRIPT(Constants.Environment.System.Connection.SSH),
    BY_SQL_QUERY(Constants.Environment.System.Connection.DB),
    BY_KUBERNETES_CONFIGMAP(Constants.Environment.System.Connection.KUBERNETES_PROJECT),
    BY_KUBERNETES_IMAGES(Constants.Environment.System.Connection.KUBERNETES_PROJECT),
    BY_OPENSHIFT_CONFIGURATION(Constants.Environment.System.Connection.OPENSHIFT_SERVER),
    BY_SSM(Constants.Environment.System.Connection.HTTP);

    private UUID listValueId;

    public static TypeGettingVersion getByListValueId(UUID listValueId) {
        TypeGettingVersion result = Arrays.stream(TypeGettingVersion.values()).filter(currentType -> currentType.getListValueId().equals(listValueId)).findFirst().orElse(null);
        return result;
    }

    public String getConnectionNameByGettingType() {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return "HTTP";
            }
            case 4: 
            case 5: {
                return "HTTP-KubernetesProject";
            }
            case 6: {
                return "HTTP-OpenShiftProject";
            }
            case 2: {
                return "SSH";
            }
            case 3: {
                return "DB";
            }
        }
        return "";
    }

    @Override
    public UUID getListValueId() {
        return this.listValueId;
    }

    private TypeGettingVersion(UUID listValueId) {
        this.listValueId = listValueId;
    }
}

