/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.migration.configuration;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DbConfiguration {
    @Value(value="${jdbc.Url}")
    private String url;
    @Value(value="${jdbc.User}")
    private String user;
    @Value(value="${jdbc.Password}")
    private String password;

    @Bean
    public DataSource dataSource(Properties properties) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(this.url);
        config.setUsername(this.user);
        config.setPassword(this.password);
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        return new HikariDataSource(config);
    }
}

