/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.model.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.model.ParametersGettingVersion;
import org.qubership.atp.environments.model.ServerItf;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.SystemCategory;
import org.qubership.atp.environments.model.impl.AbstractCreatedModified;
import org.qubership.atp.environments.model.utils.enums.Status;

public class SystemImpl
extends AbstractCreatedModified
implements System,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Environment> environments;
    private SystemCategory systemCategory;
    private List<Connection> connectionsList;
    private Status status;
    private Long dateOfLastCheck;
    private String version;
    private Long dateOfCheckVersion;
    private ParametersGettingVersion parametersGettingVersion;
    private UUID parentSystemId;
    private ServerItf serverItf;
    private Boolean mergeByName;
    private UUID linkToSystemId;
    private UUID externalId;
    private UUID sourceId;
    private String externalName;
    private transient String checkVersionError;

    public SystemImpl() {
    }

    public SystemImpl(UUID uuid, String name, String description, Long created, UUID createdBy, Long modified, UUID modifiedBy, @Nonnull List<Environment> environments, SystemCategory systemCategory, List<Connection> connectionsList, Status status, Long dateOfLastCheck, String version, Long dateOfCheckVersion, ParametersGettingVersion parametersGettingVersion, UUID parentSystemId, ServerItf serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, UUID sourceId, String externalName) {
        this.setId(uuid);
        this.setName(name);
        this.setDescription(description);
        this.setCreated(created);
        this.setCreatedBy(createdBy);
        this.setModified(modified);
        this.setModifiedBy(modifiedBy);
        this.setEnvironments(environments);
        this.setSystemCategory(systemCategory);
        this.setConnections(connectionsList);
        this.setStatus(status);
        this.setDateOfLastCheck(dateOfLastCheck);
        this.setVersion(version);
        this.setDateOfCheckVersion(dateOfCheckVersion);
        this.setParametersGettingVersion(parametersGettingVersion);
        this.setParentSystemId(parentSystemId);
        this.setServerItf(serverItf);
        this.setMergeByName(mergeByName);
        this.setLinkToSystemId(linkToSystemId);
        this.setExternalId(externalId);
        this.setSourceId(sourceId);
        this.setExternalName(externalName);
    }

    @Override
    public List<Environment> getEnvironmentIds() {
        return this.environments;
    }

    @Override
    public void setEnvironmentIds(@Nonnull List<Environment> environments) {
        this.setEnvironments(environments);
    }

    @Override
    public List<Environment> getEnvironments() {
        return this.environments;
    }

    @Override
    public void setEnvironments(@Nonnull List<Environment> environments) {
        this.environments = environments;
    }

    @Override
    public UUID getSystemCategoryId() {
        return Optional.ofNullable(this.getSystemCategory()).map(Identified::getId).orElse(null);
    }

    @Override
    public SystemCategory getSystemCategory() {
        return this.systemCategory;
    }

    @Override
    public void setSystemCategory(SystemCategory systemCategory) {
        this.systemCategory = systemCategory;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public List<Connection> getConnections() {
        return this.connectionsList;
    }

    @Override
    public void setConnections(List<Connection> connectionsList) {
        this.connectionsList = connectionsList;
    }

    @Override
    public Long getDateOfLastCheck() {
        return this.dateOfLastCheck;
    }

    @Override
    public void setDateOfLastCheck(Long dateOfLastCheck) {
        this.dateOfLastCheck = dateOfLastCheck;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    @Override
    public Long getDateOfCheckVersion() {
        return this.dateOfCheckVersion;
    }

    @Override
    public void setDateOfCheckVersion(Long dateOfCheckVersion) {
        this.dateOfCheckVersion = dateOfCheckVersion;
    }

    @Override
    public ParametersGettingVersion getParametersGettingVersion() {
        return this.parametersGettingVersion;
    }

    @Override
    public void setParametersGettingVersion(@Nonnull ParametersGettingVersion parametersGettingVersion) {
        this.parametersGettingVersion = parametersGettingVersion;
    }

    @Override
    public UUID getParentSystemId() {
        return this.parentSystemId;
    }

    @Override
    public void setParentSystemId(UUID parentSystemId) {
        this.parentSystemId = parentSystemId;
    }

    @Override
    @Nullable
    public ServerItf getServerItf() {
        return this.serverItf;
    }

    @Override
    public void setServerItf(@Nonnull ServerItf serverItf) {
        this.serverItf = serverItf;
    }

    @Override
    @Nullable
    public Boolean getMergeByName() {
        return this.mergeByName;
    }

    @Override
    public void setMergeByName(Boolean mergeByName) {
        this.mergeByName = mergeByName;
    }

    @Override
    @Nullable
    public UUID getLinkToSystemId() {
        return this.linkToSystemId;
    }

    @Override
    public void setLinkToSystemId(UUID linkToSystemId) {
        this.linkToSystemId = linkToSystemId;
    }

    @Override
    @Nullable
    public UUID getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(UUID externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getExternalName() {
        return this.externalName;
    }

    @Override
    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    @Override
    public String getCheckVersionError() {
        return this.checkVersionError;
    }

    @Override
    public void setCheckVersionError(String error) {
        this.checkVersionError = error;
    }

    @Override
    @Nullable
    public UUID getSourceId() {
        return this.sourceId;
    }

    @Override
    public void setSourceId(@Nullable UUID sourceId) {
        this.sourceId = sourceId;
    }

    public static SystemImplBuilder builder() {
        return new SystemImplBuilder();
    }

    public static class SystemImplBuilder {
        private UUID uuid;
        private String name;
        private String description;
        private Long created;
        private UUID createdBy;
        private Long modified;
        private UUID modifiedBy;
        private List<Environment> environments;
        private SystemCategory systemCategory;
        private List<Connection> connectionsList;
        private Status status;
        private Long dateOfLastCheck;
        private String version;
        private Long dateOfCheckVersion;
        private ParametersGettingVersion parametersGettingVersion;
        private UUID parentSystemId;
        private ServerItf serverItf;
        private Boolean mergeByName;
        private UUID linkToSystemId;
        private UUID externalId;
        private UUID sourceId;
        private String externalName;

        SystemImplBuilder() {
        }

        public SystemImplBuilder uuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public SystemImplBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SystemImplBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SystemImplBuilder created(Long created) {
            this.created = created;
            return this;
        }

        public SystemImplBuilder createdBy(UUID createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public SystemImplBuilder modified(Long modified) {
            this.modified = modified;
            return this;
        }

        public SystemImplBuilder modifiedBy(UUID modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this;
        }

        public SystemImplBuilder environments(@Nonnull List<Environment> environments) {
            if (environments == null) {
                throw new NullPointerException("environments is marked non-null but is null");
            }
            this.environments = environments;
            return this;
        }

        public SystemImplBuilder systemCategory(SystemCategory systemCategory) {
            this.systemCategory = systemCategory;
            return this;
        }

        public SystemImplBuilder connectionsList(List<Connection> connectionsList) {
            this.connectionsList = connectionsList;
            return this;
        }

        public SystemImplBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public SystemImplBuilder dateOfLastCheck(Long dateOfLastCheck) {
            this.dateOfLastCheck = dateOfLastCheck;
            return this;
        }

        public SystemImplBuilder version(String version) {
            this.version = version;
            return this;
        }

        public SystemImplBuilder dateOfCheckVersion(Long dateOfCheckVersion) {
            this.dateOfCheckVersion = dateOfCheckVersion;
            return this;
        }

        public SystemImplBuilder parametersGettingVersion(ParametersGettingVersion parametersGettingVersion) {
            this.parametersGettingVersion = parametersGettingVersion;
            return this;
        }

        public SystemImplBuilder parentSystemId(UUID parentSystemId) {
            this.parentSystemId = parentSystemId;
            return this;
        }

        public SystemImplBuilder serverItf(ServerItf serverItf) {
            this.serverItf = serverItf;
            return this;
        }

        public SystemImplBuilder mergeByName(Boolean mergeByName) {
            this.mergeByName = mergeByName;
            return this;
        }

        public SystemImplBuilder linkToSystemId(UUID linkToSystemId) {
            this.linkToSystemId = linkToSystemId;
            return this;
        }

        public SystemImplBuilder externalId(UUID externalId) {
            this.externalId = externalId;
            return this;
        }

        public SystemImplBuilder sourceId(UUID sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public SystemImplBuilder externalName(String externalName) {
            this.externalName = externalName;
            return this;
        }

        public SystemImpl build() {
            return new SystemImpl(this.uuid, this.name, this.description, this.created, this.createdBy, this.modified, this.modifiedBy, this.environments, this.systemCategory, this.connectionsList, this.status, this.dateOfLastCheck, this.version, this.dateOfCheckVersion, this.parametersGettingVersion, this.parentSystemId, this.serverItf, this.mergeByName, this.linkToSystemId, this.externalId, this.sourceId, this.externalName);
        }

        public String toString() {
            return "SystemImpl.SystemImplBuilder(uuid=" + this.uuid + ", name=" + this.name + ", description=" + this.description + ", created=" + this.created + ", createdBy=" + this.createdBy + ", modified=" + this.modified + ", modifiedBy=" + this.modifiedBy + ", environments=" + this.environments + ", systemCategory=" + this.systemCategory + ", connectionsList=" + this.connectionsList + ", status=" + (Object)((Object)this.status) + ", dateOfLastCheck=" + this.dateOfLastCheck + ", version=" + this.version + ", dateOfCheckVersion=" + this.dateOfCheckVersion + ", parametersGettingVersion=" + this.parametersGettingVersion + ", parentSystemId=" + this.parentSystemId + ", serverItf=" + this.serverItf + ", mergeByName=" + this.mergeByName + ", linkToSystemId=" + this.linkToSystemId + ", externalId=" + this.externalId + ", sourceId=" + this.sourceId + ", externalName=" + this.externalName + ")";
        }
    }
}

