/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.environments.model;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.qubership.atp.environments.model.utils.View;

import com.fasterxml.jackson.annotation.JsonView;

public interface CreatedModified extends Identified {

    @JsonView({View.CreatedModified.class})
    @Nonnull
    Long getCreated();

    void setCreated(@Nonnull Long created);

    @JsonView({View.CreatedModified.class})
    @Nullable
    UUID getCreatedBy();

    void setCreatedBy(@Nullable UUID createdBy);

    @JsonView({View.CreatedModified.class})
    @Nullable
    Long getModified();

    void setModified(@Nullable Long modified);

    @JsonView({View.CreatedModified.class})
    @Nullable
    UUID getModifiedBy();

    void setModifiedBy(@Nonnull UUID modifiedBy);
}
