/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.itf.lite.backend.feign.dto;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;

import org.qubership.atp.itf.lite.backend.feign.dto.history.ActionParameterDto;

public class ActionEntityDto implements Serializable {

  private static final long serialVersionUID = 1L;

  private EngineTypeEnum engineType;
  private UUID id;
  private String name;
  private List<ActionParameterDto> parameters;

  public ActionEntityDto name(String name) {
    this.name = name;
    return this;
  }

  public ActionEntityDto parameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }
}