--liquibase formatted sql
CREATE TABLE IF NOT EXISTS JV_COMMIT (
    COMMIT_PK           BIGINT NOT NULL,
    AUTHOR              VARCHAR(200),
    COMMIT_DATE         TIMESTAMP,
    COMMIT_DATE_INSTANT VARCHAR(30),
    COMMIT_ID           NUMERIC(22, 2),
    CONSTRAINT JV_COMMIT_PK
        PRIMARY KEY(COMMIT_PK)
);
CREATE INDEX IF NOT EXISTS JV_COMMIT_COMMIT_ID_IDX
    ON JV_COMMIT(COMMIT_ID);
CREATE SEQUENCE IF NOT EXISTS JV_COMMIT_PK_SEQ;

CREATE TABLE IF NOT EXISTS JV_COMMIT_PROPERTY (
    PROPERTY_NAME       VARCHAR(191) NOT NULL,
    PROPERTY_VALUE      VARCHAR(600),
    COMMIT_FK           BIGINT,
    CONSTRAINT JV_COMMIT_PROPERTY_PK
        PRIMARY KEY(COMMIT_FK, PROPERTY_NAME),
    CONSTRAINT JV_COMMIT_PROPERTY_COMMIT_FK
        FOREIGN KEY(COMMIT_FK) REFERENCES JV_COMMIT(COMMIT_PK)
);
CREATE INDEX IF NOT EXISTS JV_COMMIT_PROPERTY_COMMIT_FK_IDX
    ON JV_COMMIT_PROPERTY(COMMIT_FK);
CREATE INDEX IF NOT EXISTS JV_COMMIT_PROPERTY_PROPERTY_NAME_PROPERTY_VALUE_IDX
    ON JV_COMMIT_PROPERTY(PROPERTY_NAME, PROPERTY_VALUE);

CREATE TABLE IF NOT EXISTS JV_GLOBAL_ID (
    GLOBAL_ID_PK        BIGINT NOT NULL,
    LOCAL_ID            VARCHAR(191),
    FRAGMENT            VARCHAR(200),
    TYPE_NAME           VARCHAR(200),
    OWNER_ID_FK         BIGINT,
    CONSTRAINT JV_GLOBAL_ID_PK
        PRIMARY KEY(GLOBAL_ID_PK),
    CONSTRAINT JV_GLOBAL_ID_OWNER_ID_FK
        FOREIGN KEY(OWNER_ID_FK) REFERENCES JV_GLOBAL_ID(GLOBAL_ID_PK)
);
CREATE INDEX IF NOT EXISTS JV_GLOBAL_ID_LOCAL_ID_IDX ON JV_GLOBAL_ID(LOCAL_ID);
CREATE INDEX IF NOT EXISTS JV_GLOBAL_ID_OWNER_ID_FK_IDX ON JV_GLOBAL_ID(OWNER_ID_FK);
CREATE SEQUENCE IF NOT EXISTS JV_GLOBAL_ID_PK_SEQ;

CREATE TABLE IF NOT EXISTS JV_SNAPSHOT (
    SNAPSHOT_PK         BIGINT NOT NULL,
    TYPE                VARCHAR(200),
    VERSION             BIGINT,
    STATE               TEXT,
    CHANGED_PROPERTIES  TEXT,
    MANAGED_TYPE        VARCHAR(200),
    GLOBAL_ID_FK        BIGINT,
    COMMIT_FK           BIGINT,
    CONSTRAINT JV_SNAPSHOT_PK
        PRIMARY KEY(SNAPSHOT_PK),
    CONSTRAINT JV_SNAPSHOT_GLOBAL_ID_FK
        FOREIGN KEY(GLOBAL_ID_FK) REFERENCES JV_GLOBAL_ID(GLOBAL_ID_PK),
    CONSTRAINT JV_SNAPSHOT_CONSTRAINT
        FOREIGN KEY(COMMIT_FK) REFERENCES JV_COMMIT(COMMIT_PK)
);

CREATE INDEX IF NOT EXISTS JV_SNAPSHOT_GLOBAL_ID_FK_IDX ON JV_SNAPSHOT(GLOBAL_ID_FK);

CREATE INDEX IF NOT EXISTS JV_SNAPSHOT_COMMIT_FK_IDX ON JV_SNAPSHOT(COMMIT_FK);

CREATE SEQUENCE IF NOT EXISTS JV_SNAPSHOT_PK_SEQ;

CREATE TABLE IF NOT EXISTS SHEDLOCK (
    NAME VARCHAR(64),
    LOCK_UNTIL TIMESTAMP WITHOUT TIME ZONE NULL,
    LOCKED_AT TIMESTAMP WITHOUT TIME ZONE NULL,
    LOCKED_BY VARCHAR(255),
    PRIMARY KEY (NAME)
);




